package org.lsst.gruth.jutils;

import java.util.Map;

/**
 * this class replaces the initial <TT>ComponentNode</TT>: its content is only about
 * description of classes and parameters it does not contain actual components
 * (represented  by <TT>EffectiveNode</TT> objects))
 * @ImplNote
 * now each "value" of a Descriptive Node should be a <TT>Class</TT> Object
 * (or an "ImplPlaceHolder" pointing to Class Object).
 * This could be changed to names of Classes: we will avoid sending class objects
 * to ObjectStream data (for instance when we serialize description objects)
 * @author bamade
 */
// Date: 22/07/2014

public class DescriptiveNode extends ComponentNode<DescriptiveNode> implements Cloneable{
    public DescriptiveNode(DescriptiveNode parent, Object name) {
        super(parent, name);
    }

    public DescriptiveNode(DescriptiveNode parent, Object name, Object value) {
        super(parent, name, value);
    }

    public DescriptiveNode(DescriptiveNode parent, Object name, Map attributes) {
        super(parent, name, attributes);
    }

    public DescriptiveNode(DescriptiveNode parent, Object name, Map attributes, Object value) {
        super(parent, name, attributes, value);
    }

    public DescriptiveNode clone() {
        Map newAttributes = attributes;
        if (attributes instanceof MapArgs) {
            newAttributes = ((MapArgs) attributes).clone();
        }
        //ComponentNode res = new ComponentNode(parent,name, newAttributes, realValue);
        DescriptiveNode res = new DescriptiveNode((DescriptiveNode) null, name, newAttributes, realValue) ;
        //bug here the top node is not with the correct key so we need to change it!

        res.setSimpleDescription(simpleDescription);
        if (children != null) {
            for (DescriptiveNode child : children) {
                DescriptiveNode newChild = child.clone();
                newChild.parent = null;
                res.addChild(newChild);
            }
        }
        //if (calls != null) res.calls = calls.clone();
        // there is not reason to duplicate the calls node
        if (calls != null) res.calls = calls ;

        return  res;
    }




}
