package org.lsst.gruth.jutils;

import org.lsst.gruth.types.GArray;
import org.lsst.gruth.types.IncompatibleTypeException;

import java.io.Serializable;
import java.util.Map;

/**
 * A parameter which is an array.
 * these keep their initial type used for creation (so no no-arg contructor).
 *
 * @author bamade
 */
// Date: 02/10/12

public class ArrayParm  extends HollowParm<Serializable>{
    private Class initialType ;

    public ArrayParm(int[] args){
        super(args) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(byte[] args){
        super(args) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(boolean[] args){
        super(args) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(float[] args){
        super(args) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(double[] args){
        super(args) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(char[] args){
        super(args) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(Object[] args){
        super(args) ;
        initialType = args.getClass() ;
    }


    public ArrayParm(int[] args, Map map){
        super(args, map) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(byte[] args, Map map){
        super(args, map) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(boolean[] args, Map map){
        super(args, map) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(float[] args, Map map){
        super(args, map) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(double[] args, Map map){
        super(args, map) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(char[] args, Map map){
        super(args, map) ;
        initialType = args.getClass() ;
    }
    public ArrayParm(Object[] args, Map map){
        super(args, map) ;
        initialType = args.getClass() ;
    }

    public void setValue(Serializable arg) {
        throw new UnsupportedOperationException("only arrays supported");
    }

    public void setValue(int[] args) {
        modifyChecked(args);
    }
    public void setValue(byte[] args) {
        modifyChecked(args);
    }
    public void setValue(double[] args) {
        modifyChecked(args);
    }
    public void setValue(boolean[] args) {
        modifyChecked(args);
    }
    public void setValue(float[] args) {
        modifyChecked(args);
    }
    public void setValue(char[] args) {
        modifyChecked(args);
    }
    public void setValue(Object[] args) {
        modifyChecked(args);
    }

    @Override
    public Class getValueClass() {
        return initialType;
    }

   @Override
    public void modifyChecked(Object obj){
       if (readOnly) return ;
       if(obj == null) {
           setNullValue();
           return ;
       }
       if(obj instanceof String){
           obj = GArray.valueOf((String)obj, getValueClass().getName());
       }
       Class clazz = obj.getClass() ;
       if(initialType.isAssignableFrom(clazz)) {
           this.value = (Serializable) obj ;
       } else {
           throw new IncompatibleTypeException(initialType, clazz);
       }
   }
}
