/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.example.e02;

import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.ModuleConfigCommand;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.example.e02.main_e03;

public class ListenInfoStatusBsus
extends BusMaster {
    main_e03 aModuleObser;

    public ListenInfoStatusBsus(main_e03 obs) {
        this.setName("main");
        this.aModuleObser = obs;
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
    }

    public void onStatus(BusMessage s) {
        ValueNotification dt;
        String inputName = "MySignal";
        try {
            TrendingStatus ms = (TrendingStatus)s;
            dt = (ValueNotification)ms.getValue();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (dt.getName().equals(inputName)) {
            this.aModuleObser.processStatusInfo(dt);
        }
    }

    private Object parse(String s) {
        if (s.matches("-?[0-9]+")) {
            return Integer.parseInt(s);
        }
        if (s.matches("-?[0-9]*.[0-9]*|-?[0-9]*.[0-9]*e-?[0-9]+")) {
            return Double.parseDouble(s);
        }
        return s;
    }

    public void commandOffset(String offset) {
        String dest = "ccs-e01";
        String name = "sine/dc";
        ModuleConfigCommand cmd = new ModuleConfigCommand();
        System.out.printf("dest %s\n", dest);
        System.out.printf("name %s\n", name);
        System.out.println(offset);
        Object value = this.parse(offset);
        cmd.put(name, value);
        cmd.setDestination(dest);
        cmd.setOrigin(this.getName());
        System.out.println(cmd);
        this.fac.sendCommand((Command)cmd);
    }
}

