package org.lsst.ccs.example.e02;


import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ModuleConfigCommand;
import org.lsst.ccs.bus.ValueNotification;
//import org.lsst.ccs.bus.MessagingFactory;

public class ListenInfoStatusBsus extends BusMaster {

	main_e03 aModuleObser;
	//MessagingFactory fac = MessagingFactory.getInstance();
	
	public ListenInfoStatusBsus(main_e03 obs) {
		super();
		setName("main");
		aModuleObser = obs;
		setListenToStatus(true);
		setStatusBroadcastPeriod(0);
		
		//System.out.println("ListenInfoStatusBsus constructor");
		start();
	}

	@Override
	public void onStatus(BusMessage s) {		
		/* keep only message name is "MySignal" */		
		String inputName = "MySignal";
		
		//System.out.println("ListenInfoStatusBsus onStatus");
		TrendingStatus ms;
                ValueNotification dt;
		try {
			ms = (TrendingStatus)s;
                        dt = (ValueNotification) ms.getValue();
		}
		catch (ClassCastException e){
			return;
		}
		
		if ( dt.getName().equals(inputName)) {
			/* this status message is for me, process it by Module*/
			aModuleObser.processStatusInfo(dt);
		}
	}	
	
	private Object parse(String s) {
		if (s.matches("-?[0-9]+"))
			return Integer.parseInt(s);
		else if (s.matches("-?[0-9]*.[0-9]*|-?[0-9]*.[0-9]*e-?[0-9]+"))
			return Double.parseDouble(s);
		else
			return s;
	}	
	
	public void commandOffset(String offset)
	{
		String dest="ccs-e01";
		String name="sine/dc";
		
		ModuleConfigCommand cmd = new ModuleConfigCommand();
		System.out.printf("dest %s\n",dest);
		System.out.printf("name %s\n",name);

		System.out.println(offset);
		Object value = parse(offset);
		cmd.put(name, value);
		cmd.setDestination(dest);
		cmd.setOrigin(this.getName());
		System.out.println(cmd);		
		fac.sendCommand(cmd);
	}
}
