/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.elog;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.lsst.ccs.elog.ElogEntry;
import org.lsst.ccs.elog.ElogEntrySummary;
import org.lsst.ccs.elog.ElogTransactionResult;

public class ELogConnection
implements Closeable {
    private final URI baseURI;
    private final Random random = new SecureRandom();
    private final String eLogXmlUser = System.getProperty("org.lsst.ccs.elog.xml.user", "xml-user");
    private final String eLogXmlPwd = System.getProperty("org.lsst.ccs.elog.xml.password", "xml-lsst");
    private final int timeout = Integer.getInteger("org.lsst.ccs.elog.timeout", 5000);
    private final CloseableHttpClient client;

    public ELogConnection(String baseURL) throws URISyntaxException {
        this(new URI(baseURL));
    }

    public ELogConnection(URI baseURI) {
        this.baseURI = baseURI;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.timeout).setConnectionRequestTimeout(this.timeout).setSocketTimeout(this.timeout).build();
        this.client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    private String getSalt() {
        int i = this.random.nextInt(1234567890);
        return this.convertToMD5Hex(String.valueOf(++i));
    }

    private String convertToMD5Hex(String someText) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(someText.getBytes());
            byte[] byteData = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Error during convertToMD5Hex", ex);
        }
    }

    private void addSignature(HttpRequestBase method, String args, String body) {
        String signature = args + ":" + this.eLogXmlPwd + ":" + body;
        method.addHeader("X-Signature-Method", "md5");
        method.addHeader("X-User", this.eLogXmlUser);
        method.addHeader("X-Signature", this.convertToMD5Hex(signature));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getCategories() throws IOException {
        String salt = "salt=" + this.getSalt();
        URI requestURI = URIUtils.resolve((URI)this.baseURI, (String)("A/xml_category_list?" + salt));
        HttpGet get = new HttpGet(requestURI);
        try {
            this.addSignature((HttpRequestBase)get, salt, "");
            Throwable throwable = null;
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);){
                if (response.getStatusLine().getStatusCode() != 200) throw new IOException("Bad return code: " + response.getStatusLine().getStatusCode());
                SAXBuilder builder = new SAXBuilder();
                try {
                    Document d = builder.build(response.getEntity().getContent());
                    Element root = d.getRootElement();
                    List cats = root.getChildren("category");
                    ArrayList<String> categories = new ArrayList<String>();
                    for (Element cat : cats) {
                        categories.add(cat.getAttributeValue("path"));
                    }
                    ArrayList<String> arrayList = categories;
                    return arrayList;
                }
                catch (JDOMException e) {
                    try {
                        throw new IOException("XML exception while getting categories", e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getTags() throws IOException {
        String salt = "salt=" + this.getSalt();
        URI requestURI = URIUtils.resolve((URI)this.baseURI, (String)("A/xml_tag_list?" + salt));
        HttpGet get = new HttpGet(requestURI);
        try {
            this.addSignature((HttpRequestBase)get, salt, "");
            try {
                Throwable throwable;
                CloseableHttpResponse response;
                block18: {
                    ArrayList<String> arrayList;
                    block19: {
                        response = this.client.execute((HttpUriRequest)get);
                        throwable = null;
                        if (response.getStatusLine().getStatusCode() != 200) break block18;
                        SAXBuilder builder = new SAXBuilder();
                        Document d = builder.build(response.getEntity().getContent());
                        Element root = d.getRootElement();
                        List allTags = root.getChildren("tag");
                        ArrayList<String> tags = new ArrayList<String>();
                        for (Element tag : allTags) {
                            tags.add(tag.getAttributeValue("name"));
                        }
                        arrayList = tags;
                        if (response == null) return arrayList;
                        if (throwable == null) break block19;
                        try {
                            response.close();
                            return arrayList;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return arrayList;
                        }
                    }
                    response.close();
                    return arrayList;
                }
                try {
                    try {
                        throw new IOException("Bad return code: " + response.getStatusLine().getStatusCode());
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (response == null) throw throwable4;
                    if (throwable != null) {
                        try {
                            response.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                    response.close();
                    throw throwable4;
                }
            }
            catch (JDOMException e) {
                throw new IOException("XML exception while getting tags", e);
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * Exception decompiling
     */
    public ElogTransactionResult postEntryToElog(ElogEntry entry) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ElogEntrySummary> search(String query) throws IOException {
        String salt = "salt=" + this.getSalt();
        String args = query + "&" + salt;
        URI requestURI = URIUtils.resolve((URI)this.baseURI, (String)("E/xml_search?" + args));
        HttpGet get = new HttpGet(requestURI);
        try {
            this.addSignature((HttpRequestBase)get, args, "");
            Throwable throwable = null;
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);){
                if (response.getStatusLine().getStatusCode() != 200) throw new IOException("Bad return code: " + response.getStatusLine().getStatusCode());
                SAXBuilder builder = new SAXBuilder();
                try {
                    Document d = builder.build(response.getEntity().getContent());
                    Element root = d.getRootElement();
                    List ents = root.getChildren("entry");
                    TreeMap<Integer, ElogEntrySummary> entries = new TreeMap<Integer, ElogEntrySummary>();
                    for (Element ent : ents) {
                        Integer id = new Integer("-" + ent.getAttributeValue("id"));
                        ElogEntrySummary summary = new ElogEntrySummary(ent);
                        entries.put(id, summary);
                    }
                    ArrayList arrayList = new ArrayList(entries.values());
                    return arrayList;
                }
                catch (JDOMException e) {
                    try {
                        throw new IOException("XML exception while getting entries", e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

