/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.elog;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.elog.ELogConnectionUtils;
import org.lsst.ccs.elog.ElogEntry;
import org.lsst.ccs.elog.ElogEntrySummary;
import org.lsst.ccs.elog.ElogTransactionResult;

public class ELogConnectionUtilsTest {
    @Test
    public void testGetVersions() {
        Object[] result = ELogConnectionUtils.getVersions();
        Assert.assertArrayEquals((Object[])new String[]{"development", "production"}, (Object[])result);
    }

    @Test
    public void testGetCategories() throws IOException {
        List categories = ELogConnectionUtils.getCategories((String)"production");
        Assert.assertTrue((categories.size() > 10 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)categories.contains("eLogTesting"));
    }

    @Test
    public void testGetTags() throws IOException {
        List tags = ELogConnectionUtils.getTags((String)"production");
        Assert.assertTrue((tags.size() > 10 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tags.contains("SLAC"));
    }

    @Test
    public void testPostEntryToElog() throws IOException {
        ElogEntry entry = new ElogEntry();
        entry.setAuthor("turri");
        entry.setFormName("default");
        entry.setCategory("Testing");
        entry.setFormatted(true);
        entry.setFormField("text", "This is just a test. HTML is allowed here: blah blah blah  <table>     <tr>         <th>Name</th><th>Value</th>     </tr>     <tr><td>Red</td><td>100</td></tr>     <tr><td>Green</td><td>150</td></tr>     <tr><td>Blue</td><td>200</td></tr> </table>");
        InputStream img = this.getClass().getResourceAsStream("testImage.png");
        InputStream attach = this.getClass().getResourceAsStream("test.txt");
        entry.addAttachment("attach", IOUtils.toByteArray((InputStream)attach));
        entry.addImage("conf logo", IOUtils.toByteArray((InputStream)img));
        ElogTransactionResult result = ELogConnectionUtils.postEntryToElog((ElogEntry)entry, (String)"development");
        Assert.assertEquals((long)200L, (long)result.getStatus());
        Assert.assertTrue((boolean)Pattern.compile("Created \\d+").matcher(result.getResponse()).find());
    }

    @Test
    public void testSearch() throws IOException {
        String magic = "BE1zlAMHk9RjLVB2x3";
        List entries = ELogConnectionUtils.search((String)("si=" + magic), (String)"development");
        Assert.assertTrue((entries.size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((ElogEntrySummary)entries.get(0)).getText().contains(magic));
    }
}

