package org.lsst.ccs.elog;

import java.util.List;

import org.jdom.Content;
import org.jdom.Element;

/**
 *
 * @author focke
 */
public class ElogEntrySummary {
    
    private Integer id;
    private String author;
    private String category;
    private String timestamp; /*fix this?*/
    private Boolean html;
    private Boolean formatted;
    private String form;
    private Integer images;
    private Integer files;
    private String text;
    private String textHtml;
    private String textCdata;
    
    public ElogEntrySummary() {
    }
    
    public ElogEntrySummary(Element entry) {
        id = new Integer(entry.getAttributeValue("id"));
        author = entry.getAttributeValue("author");
        category = entry.getAttributeValue("category");
        timestamp = entry.getAttributeValue("timestamp");
        html = new Boolean(entry.getAttributeValue("html"));
        formatted = new Boolean(entry.getAttributeValue("formatted"));
        form = entry.getAttributeValue("form");
        images = new Integer(entry.getAttributeValue("images"));
        files = new Integer(entry.getAttributeValue("files"));
        
        Element child = entry.getChild("text");
        List<Content> conts = child.getContent();
        text = "";
        for (Content cont : conts) {
            text += cont.getValue();
        }
        
        child = entry.getChild("text-html");
        conts = child.getContent();
        textHtml = "";
        for (Content cont : conts) {
            textHtml += cont.getValue();
        }
        
        child = entry.getChild("text-cdata");
        conts = child.getContent();
        textCdata = "";
        for (Content cont : conts) {
            textCdata += cont.getValue();
        }
   }
    
    public void setId(Integer id) {
        this.id = id;
    }
    
    public Integer getId() {
        return id;
    }
    
    public void setAuthor(String author) {
        this.author = author;
    }
    
    public String getAuthor() {
        return author;
    }
    
    public void setCategory(String category) {
        this.category = category;
    }
    
    public String getCategory() {
        return category;
    }
    
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }
    
    public String getTimestamp() {
        return timestamp;
    }
    
    public void setHtml(Boolean html) {
        this.html = html;
    }
    
    public boolean getHtml() {
        return html;
    }
    
    public void setFormatted(Boolean formatted) {
        this.formatted = formatted;
    }
    
    public boolean getFormatted() {
        return formatted;
    }

    public void setForm(String form) {
        this.form = form;
    }
    
    public String getForm() {
        return form;
    }
    
    public void setImages(Integer images) {
        this.images = images;
    }
    
    public int getImages() {
        return images;
    }
    
    public void setFiles(Integer files) {
        this.files = files;
    }
    
    public int getFiles() {
        return files;
    }
    
    public void setText(String text) {
        this.text = text;
    }
    
    public String getText() {
        return text;
    }
    
    public void setTextHtml(String textHtml) {
        this.textHtml = textHtml;
    }
    
    public String getTextHtml() {
        return textHtml;
    }
    
    public void setTextCdata(String textCdata) {
        this.textCdata = textCdata;
    }
    
    public String getTextCdata() {
        return textCdata;
    }
}
