package org.lsst.ccs.elog;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.HashMap;

/**
 * 
 * @author turri
 */
public class ELogConnectionUtils {
    
    private static final HashMap<String, String> versions = new HashMap<>();
    
    // TODO: Check if these are the up-to-date URLs
    private static void setUrlMap (){
        versions.put("production", "http://dbweb5.fnal.gov:8080/ECL/lsst_camera");
        versions.put("development", "http://dbweb5.fnal.gov:8080/ECL/lsst_camera_dev");
    }
    
    /**
     * Get the versions supported by this class. By default this is production+development
     * @return An array of available versions
     */
    public static String[] getVersions() {
        if (versions.isEmpty()) setUrlMap();
        String[] vers = new String[versions.size()]; 
        return versions.keySet().toArray(vers);
    }

    private static String getElogUrl(String version) {

        if (versions.isEmpty()) setUrlMap();
        String eLogUrl = System.getProperty("org.lsst.ccs.elog.xml.url", versions.get(version));
        if ( ! eLogUrl.endsWith("/") ) {
            eLogUrl += "/";
        }
        return eLogUrl;
    }
    
    public static List<String> getCategories(String version) throws IOException {
        try (ELogConnection conn = new ELogConnection(getElogUrl(version))) {
            return conn.getCategories();
        } catch (URISyntaxException ex) {
            throw new IOException("Invalid URL",ex);
        }
    }
    
    public static List<String> getTags(String version) throws IOException {
        try (ELogConnection conn = new ELogConnection(getElogUrl(version))) {
            return conn.getTags();
        } catch (URISyntaxException ex) {
            throw new IOException("Invalid URL",ex);
        }
    }
    
    public static List<ElogEntrySummary> search(String query, String version) throws IOException {
        try (ELogConnection conn = new ELogConnection(getElogUrl(version))) {
            return conn.search(query);
        } catch (URISyntaxException ex) {
            throw new IOException("Invalid URL",ex);
        }
    }
    
    
    
    public static ElogTransactionResult postEntryToElog(ElogEntry entry, String version) throws IOException {
        try (ELogConnection conn = new ELogConnection(getElogUrl(version))) {
            return conn.postEntryToElog(entry);
        } catch (URISyntaxException ex) {
            throw new IOException("Invalid URL",ex);
        }
    }
}
