/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.elog;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.lsst.ccs.elog.ELogConnection;
import org.lsst.ccs.elog.ElogEntry;
import org.lsst.ccs.elog.ElogTransactionResult;

public class ELogConnectionUtils {
    private static final HashMap<String, String> versions = new HashMap();

    private static void setUrlMap() {
        versions.put("production", "http://dbweb5.fnal.gov:8080/ECL/lsst_camera");
        versions.put("development", "http://dbweb5.fnal.gov:8080/ECL/lsst_camera_dev");
    }

    public static String[] getVersions() {
        if (versions.isEmpty()) {
            ELogConnectionUtils.setUrlMap();
        }
        String[] vers = new String[versions.size()];
        return versions.keySet().toArray(vers);
    }

    private static String getElogUrl(String version) {
        String eLogUrl;
        if (versions.isEmpty()) {
            ELogConnectionUtils.setUrlMap();
        }
        if (!(eLogUrl = System.getProperty("org.lsst.ccs.elog.xml.url", versions.get(version))).endsWith("/")) {
            eLogUrl = eLogUrl + "/";
        }
        return eLogUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getCategories(String version) throws IOException {
        try (ELogConnection conn = new ELogConnection(ELogConnectionUtils.getElogUrl(version));){
            List<String> list = conn.getCategories();
            return list;
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URL", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getTags(String version) throws IOException {
        try (ELogConnection conn = new ELogConnection(ELogConnectionUtils.getElogUrl(version));){
            List<String> list = conn.getTags();
            return list;
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URL", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ElogTransactionResult postEntryToElog(ElogEntry entry, String version) throws IOException {
        try (ELogConnection conn = new ELogConnection(ELogConnectionUtils.getElogUrl(version));){
            ElogTransactionResult elogTransactionResult = conn.postEntryToElog(entry);
            return elogTransactionResult;
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URL", ex);
        }
    }
}

