/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.elog;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.lsst.ccs.elog.ElogEntry;
import org.lsst.ccs.elog.ElogTransactionResult;

public class ELogConnectionUtils {
    private static String eLogUrl = System.getProperty("org.lsst.ccs.elog.xml.rul", "http://dbweb4.fnal.gov:8080/ECL/lsst_camera");
    private static String eLogXmlUser = System.getProperty("org.lsst.ccs.elog.xml.user", "xml-user");
    private static String eLogXmlPwd = System.getProperty("org.lsst.ccs.elog.xml.password", "xml-lsst");
    private static Random r = new Random();

    private static String convertToMD5Hex(String someText) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        md.update(someText.getBytes());
        byte[] byteData = md.digest();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < byteData.length) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return sb.toString();
    }

    private static void addSignature(HttpMethodBase method, String args, String body) {
        String signature = String.valueOf(args) + ":" + eLogXmlPwd + ":" + body;
        method.addRequestHeader("X-Signature-Method", "md5");
        method.addRequestHeader("X-User", eLogXmlUser);
        method.addRequestHeader("X-Signature", ELogConnectionUtils.convertToMD5Hex(signature));
    }

    private static String getSalt() {
        int i = r.nextInt(1234567890);
        return ELogConnectionUtils.convertToMD5Hex(String.valueOf(++i));
    }

    private static String getElogUrl() {
        if (!eLogUrl.endsWith("/")) {
            eLogUrl = String.valueOf(eLogUrl) + "/";
        }
        return eLogUrl;
    }

    public static List<String> getCategories() throws IOException {
        ArrayList<String> categories;
        block6: {
            HttpClient client = new HttpClient();
            String salt = "salt=" + ELogConnectionUtils.getSalt();
            String requestUrl = String.valueOf(ELogConnectionUtils.getElogUrl()) + "A/xml_category_list?" + salt;
            GetMethod get = new GetMethod(requestUrl);
            ELogConnectionUtils.addSignature((HttpMethodBase)get, salt, "");
            categories = new ArrayList<String>();
            try {
                int status = client.executeMethod((HttpMethod)get);
                if (status != 200) break block6;
                SAXBuilder builder = new SAXBuilder();
                try {
                    Document d = builder.build(get.getResponseBodyAsStream());
                    Element root = d.getRootElement();
                    List cats = root.getChildren("category");
                    for (Element cat : cats) {
                        categories.add(cat.getAttributeValue("path"));
                    }
                }
                catch (Exception exception) {}
            }
            finally {
                get.releaseConnection();
            }
        }
        return categories;
    }

    public static ElogTransactionResult postEntryToElog(ElogEntry entry) throws IOException {
        ElogTransactionResult result;
        HttpClient client = new HttpClient();
        String salt = "salt=" + ELogConnectionUtils.getSalt();
        String requestUrl = String.valueOf(ELogConnectionUtils.getElogUrl()) + "E/xml_post?" + salt;
        PostMethod post = new PostMethod(requestUrl);
        String body = entry.toXML();
        ELogConnectionUtils.addSignature((HttpMethodBase)post, salt, body);
        StringRequestEntity entity = null;
        try {
            entity = new StringRequestEntity(body, "text/xml", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        post.setRequestEntity((RequestEntity)entity);
        post.addRequestHeader("Content-type", "text/xml");
        try {
            int status = client.executeMethod((HttpMethod)post);
            result = new ElogTransactionResult(status, post.getResponseBodyAsString());
        }
        finally {
            post.releaseConnection();
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(ELogConnectionUtils.getCategories());
    }
}

