/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.elog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/**
 *
 * @author turri
 */
public class ELogConnectionUtils {

    private static String eLogUrl = System.getProperty("org.lsst.ccs.elog.xml.rul", "http://dbweb4.fnal.gov:8080/ECL/lsst_camera");
    private static String eLogXmlUser = System.getProperty("org.lsst.ccs.elog.xml.user", "xml-user");
    private static String eLogXmlPwd = System.getProperty("org.lsst.ccs.elog.xml.password", "xml-lsst");
    private static Random r = new Random();
    
    
    
    private static String convertToMD5Hex(String someText) {
        
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        md.update(someText.getBytes());
        byte byteData[] = md.digest();

        //convert the byte to hex format method 1
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; i++) {
            sb.append(Integer.toString((byteData[i] & 0xff) + 0x100, 16).substring(1));
        }

        return sb.toString();
        
    }

    private static void addSignature(HttpMethodBase method,String args, String body) {
        String signature = args+":"+eLogXmlPwd+":"+body;
        method.addRequestHeader("X-Signature-Method", "md5");
        method.addRequestHeader("X-User", eLogXmlUser);
        method.addRequestHeader("X-Signature", convertToMD5Hex(signature));
        
    }
    
    private static String getSalt() {
        int i = r.nextInt(1234567890);
        i++;
        return convertToMD5Hex(String.valueOf(i));
    }
    

    private static String getElogUrl() {
        if ( ! eLogUrl.endsWith("/") )
            eLogUrl += "/";
        return eLogUrl;
    }
    
    public static List<String> getCategories() throws IOException {
        HttpClient client = new HttpClient();

        String salt = "salt="+getSalt();
        String requestUrl = getElogUrl() + "A/xml_category_list?"+salt;
        GetMethod get = new GetMethod(requestUrl);

        addSignature(get,salt,"");

        ElogTransactionResult result;
        ArrayList<String> categories = new ArrayList<String>();
        try {
            // execute the POST
            int status = client.executeMethod(get);
            
            if (status == 200) {
                SAXBuilder builder = new SAXBuilder();
                try { 
                    Document d = builder.build(get.getResponseBodyAsStream());
                    Element root = d.getRootElement();
                    List<Element> cats = root.getChildren("category");
                    for (Element cat : cats) {
                        categories.add(cat.getAttributeValue("path"));
                    }
                } catch (Exception e) {
                    
                }
            }            

        } finally {
            // release any connection resources used by the method
            get.releaseConnection();
        }
        
        return categories;
        
    }
    
    
    public static ElogTransactionResult postEntryToElog(ElogEntry entry) throws IOException {
        HttpClient client = new HttpClient();

        String salt = "salt="+getSalt();
        String requestUrl = getElogUrl() + "E/xml_post?"+salt;

        PostMethod post = new PostMethod(requestUrl);
        String body = entry.toXML();
                
        addSignature(post,salt,body);
        
        RequestEntity entity = null;        
        try {
            entity = new StringRequestEntity(body,"text/xml","UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }

        post.setRequestEntity(entity);                

        //Content type for posts only
        post.addRequestHeader("Content-type", "text/xml");
        
        ElogTransactionResult result;
        
        try {
            // execute the POST
            int status = client.executeMethod(post);
            result = new ElogTransactionResult(status,post.getResponseBodyAsString());

        } finally {
            // release any connection resources used by the method
            post.releaseConnection();
        }
        
        return result;
    }
    
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws Exception {

        System.out.println(getCategories());

        
//        ElogEntry entry = new ElogEntry();
//        entry.setAuthor("turri");
//        entry.setFormName("default");
//        entry.setCategory("Testing");
//        entry.setFormatted(true);
//        entry.setFormField("text", "This is just a test. HTML is allowed here: blah blah blah "
//                +" <table>"
//                +"     <tr>"
//                +"         <th>Name</th><th>Value</th>"
//                +"     </tr>"
//                +"     <tr><td>Red</td><td>100</td></tr>"
//                +"     <tr><td>Green</td><td>150</td></tr>"
//                +"     <tr><td>Blue</td><td>200</td></tr>"
//                +" </table>");
//        
//        
//        FileInputStream img = new FileInputStream("/home/turri/Code/test/samples/confluence_48_white.png");
//        FileInputStream attach = new FileInputStream("/home/turri/Code/test/samples/some.txt");
//        entry.addAttachment("attach", IOUtils.toByteArray(attach));
//        entry.addImage("conf logo", IOUtils.toByteArray(img));
//        
//        ElogTransactionResult result = postEntryToElog(entry);
//        System.out.println("Transaction status "+result.getStatus());
//        System.out.println(result.getResponse());

    }
}
