package org.lsst.ccs.drivers.xed;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

/**
 *************************************************************************** 
 ** 
 ** Program to test the XED device driver
 ** 
 ** @author Homer
 ** 
 *************************************************************************** 
 */
public class TestXED {

	protected XED mydev;       
        
    @Command(name = "open", description = "Open a device for use")
	public void open(
            @Argument(name = "devId", description = "The device ID of the device to open") String MyDevId
                ) throws DriverException {
		
    	    mydev = new XED();
	    mydev.open(MyDevId,9600);
    }

    @Command(name = "close", description = "Close the device")
	public void close() throws Exception {
    	mydev.close();
	}

    @Command(name = "extendFe55", description = "extend arm")
	public void extendFe55(
                ) throws Exception {
    	    mydev.extendFe55();
	}

    @Command(name = "retractFe55", description = "retract arm")
	public void retractFe55(
                ) throws Exception {
    	    mydev.retractFe55();
	}
}
