/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.xed;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class XED
extends Ascii {
    private final int timeout = 5000;
    private boolean isconnected = false;

    public XED() {
        this.setOptions(Ascii.Option.NO_NET);
    }

    @Override
    public void open(DriverConstants.ConnType connType, String serialName, int baud, int dataChar) throws DriverException {
        super.open(connType, serialName, baud, 0);
        this.init();
        this.setTimeout(5000);
        try {
            this.reset();
            String response = null;
            for (int i = 0; i < 7; ++i) {
                response = this.readXED();
                System.out.println(i + " : " + response);
            }
            if (this.getIdent().contains(":")) {
                this.isconnected = true;
            } else {
                System.out.println("XED: connected to port but handshake failed!");
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to open connection to XED device!");
            this.isconnected = false;
        }
    }

    public void open(String device, int baud) throws DriverException {
        this.openSerial(device, baud);
    }

    public void init() {
        this.setCommandTerm(Ascii.Terminator.CRLF);
    }

    public void reset() throws DriverException {
        this.writeXED("h");
    }

    public String getIdent() throws DriverException {
        return this.readXED(" ");
    }

    public void extendFe55() throws DriverException {
        if (this.isconnected) {
            this.writeXED("e");
        }
    }

    public void retractFe55() throws DriverException {
        if (this.isconnected) {
            this.writeXED("r");
        }
    }

    public synchronized void writeXED(String command) throws DriverException {
        this.write(command);
    }

    public synchronized String readXED() throws DriverException {
        return this.read();
    }

    public synchronized String readXED(String command) throws DriverException {
        this.writeXED(command);
        return this.readXED();
    }
}

