package org.lsst.ccs.drivers.xed;

import java.text.DecimalFormat;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.ascii.Ascii;

/**
 **************************************************************************
 **
 ** General access routines for the XED device 
 * 
 ** @author Homer Neal
 * **************************************************************************
 */
public class XED extends Ascii {

    /**
     ** Public constants *
     **/


    /*
     ** Private constants *
     */
    private final static byte CR = 0x0d, LF = 0x0a;
    private String terminator = "\r\n";
    private int timeout = 5000;
    
    private boolean isconnected = false ;


    public XED() throws DriverException {
    }

    /**
     **
     ** Opens a connection. * * @param device The device name of the serial
     * port
     ** @param baud The baud rate
     ** @param dummy Dummy argument * * @throws DriverException *
     **/
    public void open(String serialname, int baud) throws DriverException
    {
        init();
        System.out.println("opening connection to the XED");
        try {
            open(Ascii.CONN_TYPE_SERIAL, serialname, baud);
            setTimeout(timeout);
            reset();
//            reset();
            String response = null;
            for (int i=0;i<7;i++) {
                response = readXED();
                System.out.println(i+" : "+response);
            }
//            if (getIdent().contains("XED")) {
            if (getIdent().contains(":")) {
                isconnected = true;
            } else {
                System.out.println("XED: connected to port but handshake failed!"); 
            }
        } catch (Exception ex) {
            System.out.println("Failed to open connection to XED device!");
            isconnected = false;
        }
    
    }

      /**
    **  Opens an FTDI connection.
    */
    public void openftdi(String serialname, int baud)
    {
        init();
        System.out.println("opening connection to the XED");
        try {
            open(Ascii.CONN_TYPE_FTDI, serialname, baud);
            setTimeout(timeout);
            reset();
//            reset();
            String response = null;
            for (int i=0;i<7;i++) {
                response = readXED();
                System.out.println(i+" : "+response);
            }
//            String response = getIdent();
//            System.out.println("XED reply = "+response);
//            if (response.contains("XED")) {
            if (response.contains(":")) {
                isconnected = true;
                System.out.println("Successful connection to XED");
            } else {
                System.out.println("XED: connected to port but handshake failed!"); 
            }
        } catch (Exception ex) {
            System.out.println("Failed to open connection to XED device!");
            isconnected = false;
        }
    
    }

    /**
     **  Initializes device.
     **/
    public void init()
    {
       setTerminator(terminator);
    }    
    
    /**
     ** Closes the connection. * * @throws DriverException *
     **/
    public void close() throws DriverException {
        close();
    }

 
    /** reset to factory defaults **/
    public void reset() throws DriverException {
        writeXED("h");
    }



     /** Gets the XED identity. **/
    public String getIdent() throws DriverException {
        return readXED(" ") ;
    }

    public void extendFe55() throws DriverException {
         if (isconnected) writeXED("e");
    }

    public void retractFe55() throws DriverException {
         if (isconnected) writeXED("r");
    }
    /**
     ** Sets the receive timeout. * * @param timeout The receive timeout (ms).
     * 0 means no timeout. * * @throws DriverException *
     */
    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

     /**
     ** Writes a command. * * @param command The command to write, excluding
     * terminator * * @throws DriverException *
     **/
    public synchronized void writeXED(String command) throws DriverException {
       write(command + terminator);
    }

    /**
     ** Reads a response. * * @return The command response string * * @throws
     * DriverException
     ** @throws DriverTimeoutException *
     */
    public synchronized String readXED() throws DriverException {
        return(read());
    }

    /**
     ** Reads a response after writing a command. * * @param command The
     * command to write, excluding terminator * * @return The command response
     * string * * @throws DriverException
     ** @throws DriverTimeoutException *
     */
    public synchronized String readXED(String command) throws DriverException {
        writeXED(command);
        return readXED();
    }

}
