/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.zonesui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.Toolkit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.lsst.ccs.utilities.zonesui.ImageDescription;
import org.lsst.ccs.utilities.zonesui.ImageZones;
import org.lsst.ccs.utilities.zonesui.InteractionProducer;
import org.lsst.ccs.utilities.zonesui.PositionListener;

public class ZonesPanel
extends JPanel
implements PositionListener {
    private ImageZones imgZones;
    private JLabel markCoords = new JLabel("        ", 0);

    public ZonesPanel(ImageDescription id, InteractionProducer ip) {
        this.imgZones = new ImageZones(id, ip, this);
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.imgZones, 22, 32);
        this.add(scroll);
        this.add((Component)this.markCoords, "First");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension tailleEcran = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension tailleImage = this.imgZones.getPreferredSize();
        if (tailleImage.getHeight() < tailleEcran.getHeight() && tailleImage.getWidth() < tailleEcran.getWidth()) {
            int labelHeight = this.markCoords.getHeight();
            tailleImage.setSize(tailleImage.width, labelHeight + tailleImage.height);
            return tailleImage;
        }
        return tailleEcran;
    }

    @Override
    public Dimension getMinimumSize() {
        int labelHeight = this.markCoords.getHeight();
        Dimension dims = this.imgZones.getMinimumSize();
        dims.setSize(dims.width, labelHeight + dims.height);
        return dims;
    }

    @Override
    public void currentCoords(int x, int y) {
        this.markCoords.setText("(" + x + "," + y + ")");
    }

    public void setStroke(Stroke stroke) {
        this.imgZones.setStroke(stroke);
    }

    public void setDashedLineColor(Color color) {
        this.imgZones.setDashedLineColor(color);
    }

    public void setDashedLineWidth(int points) {
        this.imgZones.setDashedLineWidth(points);
    }
}

