/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.wattsup;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.wattsup.WattsUp;

public class TestWattsUp
implements WattsUp.Listener {
    private static final Map<Integer, String> memWords = new HashMap<Integer, String>();
    private static final Map<Integer, String> logstWords;
    private static final PrintStream out;
    private final WattsUp wtu = new WattsUp();
    private int fieldMask;
    private int dataCount;
    private boolean devOpen;
    private boolean dataSumm;
    private boolean listening;
    private static final byte[] flags;

    static {
        memWords.put(0, "suspend");
        memWords.put(1, "overwrite");
        memWords.put(2, "condense");
        logstWords = new HashMap<Integer, String>();
        logstWords.put(0, "suspended");
        logstWords.put(1, "internal");
        logstWords.put(2, "external");
        out = System.out;
        flags = new byte[]{124, 47, 45, 92};
    }

    @Command(name="open", description="Open connection to meter")
    public void open(@Argument(name="serial", description="USB serial number") String serial, @Argument(name="index", description="FTDI device index") int index, @Argument(name="node", description="Remote node name") String node) throws DriverException {
        this.wtu.open(node, index, serial.equals("") ? null : serial);
        this.devOpen = true;
        this.fieldMask = this.wtu.getLoggedFields();
    }

    @Command(name="open", description="Open connection to meter")
    public void open(@Argument(name="serial", description="USB serial number") String serial, @Argument(name="index", description="FTDI device index") int index) throws DriverException {
        this.open(serial, index, null);
    }

    @Command(name="open", description="Open connection to meter")
    public void open(@Argument(name="serial", description="USB serial number") String serial) throws DriverException {
        this.open(serial, 0, null);
    }

    @Command(name="close", description="Close connection to meter")
    public void close() throws DriverException {
        this.devOpen = false;
        this.wtu.close();
    }

    @Command(name="listen", description="Enable or disable the listener")
    public void listen(@Argument(name="action", description="Action to take") OnOff action) {
        boolean bl = this.listening = action == OnOff.ON;
        if (this.listening) {
            this.wtu.addListener(this);
        } else {
            this.wtu.removeListener();
        }
    }

    @Command(name="fldset", description="Set the mask of logged fields")
    public void fldSet(@Argument(name="mask", description="Mask to set") int mask) throws DriverException {
        this.fieldMask = mask;
        out.println("Record limit = " + this.wtu.setLoggedFields(this.fieldMask));
    }

    @Command(name="fldshow", description="Show the mask of logged fields")
    public void fldShow() throws DriverException {
        out.format("Value = %08x\n", this.wtu.getLoggedFields());
    }

    @Command(name="calshow", description="Show the calibration data")
    public void calShow() throws DriverException {
        this.showIntegers(this.wtu.getCalibrationData());
    }

    @Command(name="hdrshow", description="Show the header strings")
    public void hdrShow() throws DriverException {
        this.showStrings(this.wtu.getHeaderRecord());
    }

    @Command(name="limshow", description="Show the record limit")
    public void limShow() throws DriverException {
        out.println("Record limit = " + this.wtu.getRecordLimit());
    }

    @Command(name="memset", description="Set the memory-full action")
    public void memSet(@Argument(name="action", description="Action to take") MemFullAction action) throws DriverException {
        this.wtu.setFullOption(action.getValue());
    }

    @Command(name="memshow", description="Show the memory-full action")
    public void memShow() throws DriverException {
        int option = this.wtu.getFullOption();
        out.format("Memory full option = %s (%s)\n", option, memWords.get(option));
    }

    @Command(name="intset", description="Set the logging interval")
    public void intSet(@Argument(name="intvl", description="Logging interval") int intvl) throws DriverException {
        this.wtu.setLoggingInterval(intvl);
    }

    @Command(name="logset", description="Set the logging type and interval")
    public void logSet(@Argument(name="type", description="Logging type") LogType type, @Argument(name="intvl", description="Logging Interval") int intvl) throws DriverException {
        if (type == LogType.INTERNAL) {
            intvl = this.wtu.setInternalLogging(intvl);
            out.println("Resulting interval = " + intvl);
        } else {
            this.dataSumm = false;
            this.wtu.setExternalLogging(intvl);
            if (!this.listening) {
                out.println("Turn listener on for data display");
            }
        }
    }

    @Command(name="logshow", description="Show the logging interval & state")
    public void logShow() throws DriverException {
        int state = this.wtu.getLoggingState();
        out.format("Logging interval = %s, logging state = %s (%s)\n", this.wtu.getLoggingInterval(), state, logstWords.get(state));
    }

    @Command(name="parmset", description="Set the user parameters")
    public void parmSet(@Argument(name="rate", description="Electricity rate") double rate, @Argument(name="thresh", description="Duty cycle threshold") int thresh, @Argument(name="curr", description="Currency") Currency curr) throws DriverException {
        this.wtu.setUserParameters(rate, thresh, curr == Currency.EURO);
    }

    @Command(name="parmset", description="Set the user parameters")
    public void parmSet(@Argument(name="rate", description="Electricity rate") double rate, @Argument(name="thresh", description="Duty cycle threshold") int thresh) throws DriverException {
        this.parmSet(rate, thresh, Currency.DOLLAR);
    }

    @Command(name="parmshow", description="Show the user parameters")
    public void parmShow() throws DriverException {
        out.format("Rate = %.3f, threshold = %s, euro = %s\n", this.wtu.getUserRate(), this.wtu.getUserThreshold(), this.wtu.getUserEuro());
    }

    @Command(name="vershow", description="Show the version strings")
    public void verShow() throws DriverException {
        this.showStrings(this.wtu.getVersionData());
    }

    @Command(name="reset", description="Reset memory")
    public void reset() throws DriverException {
        this.wtu.resetMemory();
    }

    @Command(name="restart", description="Restart the meter")
    public void restart() throws DriverException {
        this.wtu.restart();
    }

    @Command(name="datashow", description="Show data")
    public void dataShow(@Argument(name="type", description="Display type") DataType type) throws DriverException {
        this.dataSumm = type == DataType.SUMMARY;
        this.dataCount = 0;
        if (!this.listening) {
            out.println("Turn listener on for data display");
        }
        int interval = this.wtu.getLoggedData();
        out.println("Record count = " + this.dataCount + ", logging interval = " + interval);
        this.dataSumm = false;
    }

    @Override
    public void setPowered(boolean on) {
        out.println("Device powered " + (on ? "on" : "off"));
    }

    @Override
    public void setClosed() {
        out.println("Device connection closed");
        this.devOpen = false;
    }

    @Override
    public void processData(double[] data) {
        ++this.dataCount;
        if (this.dataSumm) {
            if ((this.dataCount & 7) == 0) {
                byte[] flag = new byte[]{flags[this.dataCount >> 3 & 3], 8};
                out.write(flag, 0, 2);
            }
        } else {
            this.showDoubles(data, this.fieldMask);
        }
    }

    private void showStrings(String[] value) {
        out.print("Values =");
        int posn = 8;
        String[] stringArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            String sValue = " " + val;
            if ((posn += sValue.length()) > 80) {
                out.print("\n        ");
                posn = 8 + sValue.length();
            }
            out.print(sValue);
            ++n2;
        }
        out.println();
    }

    private void showIntegers(int[] value) {
        out.print("Values =");
        int posn = 8;
        int[] nArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            String sValue = " " + val;
            if ((posn += sValue.length()) > 80) {
                out.print("\n        ");
                posn = 8 + sValue.length();
            }
            out.print(sValue);
            ++n2;
        }
        out.println();
    }

    private void showDoubles(double[] value, int mask) {
        out.print("Values =");
        int posn = 8;
        int j = 0;
        while (j < value.length) {
            if ((mask & 1 << j) != 0) {
                String sValue = " " + value[j];
                if ((posn += sValue.length()) > 80) {
                    out.print("\n        ");
                    posn = 8 + sValue.length();
                }
                out.print(sValue);
            }
            ++j;
        }
        out.println();
    }

    public static enum Currency {
        DOLLAR,
        EURO;

    }

    public static enum DataType {
        DETAIL,
        SUMMARY;

    }

    public static enum LogType {
        INTERNAL,
        EXTERNAL;

    }

    public static enum MemFullAction {
        SUSPEND(0),
        OVERWRITE(1),
        CONDENSE(2);

        int value;

        private MemFullAction(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum OnOff {
        ON,
        OFF;

    }
}

