/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.DefaultDictionaryCompleter;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.DictionaryHelpGenerator;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Command;

public class RoutingCommandSet
implements CommandSet {
    private final RoutingDictionary dict;
    private final String route;
    private final CommandSet cs;

    public RoutingCommandSet(String route, CommandSet cs) {
        this.route = route;
        this.cs = cs;
        this.dict = new RoutingDictionary(route, cs.getCommandDictionary());
    }

    String getRoute() {
        return this.route;
    }

    CommandSet getRouteCommandSet() {
        return this.cs;
    }

    @Override
    public Dictionary getCommandDictionary() {
        return this.dict;
    }

    @Override
    public Object invoke(BasicCommand command) throws CommandInvocationException {
        DictionaryCommand dc = this.dict.findCommand(command);
        if (dc == null) {
            throw new CommandInvocationException("Error: Cound not invoke command " + command.getCommand() + " on target " + this.getRoute(), new Object[0]);
        }
        if (command.getArgumentCount() == 0) {
            throw new CommandInvocationException("Error: To change target type the command \"set target TARGET_NAME\"", new Object[0]);
        }
        command.getCommand();
        TokenizedCommand tc = (TokenizedCommand)command;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tc.getArgumentCount()) {
            sb.append(tc.getArgument(i));
            sb.append(" ");
            ++i;
        }
        TokenizedCommand routedCommand = new TokenizedCommand(sb.toString());
        return this.getRouteCommandSet().invoke(routedCommand);
    }

    private static class RoutingCommand
    implements DictionaryCommand {
        private final String route;
        private final Dictionary dict;
        private final DictionaryArgument[] routingArgument;

        RoutingCommand(String route, Dictionary dict) {
            this.route = route;
            this.dict = dict;
            this.routingArgument = new DictionaryArgument[]{new RoutingCommandArgument(dict), new RoutingCommandArgumentsArgument()};
        }

        Dictionary getDictionary() {
            return this.dict;
        }

        @Override
        public DictionaryArgument[] getArguments() {
            return this.routingArgument;
        }

        @Override
        public String getCommandName() {
            return this.route;
        }

        @Override
        public String getDescription() {
            return "Sends commands to target's (" + this.route + ") dictionary";
        }

        @Override
        public Command.CommandType getType() {
            return Command.CommandType.QUERY;
        }

        @Override
        public boolean isVarArgs() {
            return true;
        }

        @Override
        public int getLevel() {
            return 0;
        }

        @Override
        public Command.CommandCategory getCategory() {
            return Command.CommandCategory.USER;
        }

        private static class RoutingCommandArgument
        implements DictionaryArgument {
            private final Dictionary dict;

            RoutingCommandArgument(Dictionary dict) {
                this.dict = dict;
            }

            @Override
            public String getDescription() {
                return "The command to execute";
            }

            @Override
            public String getName() {
                return "command";
            }

            @Override
            public String getSimpleType() {
                return "String";
            }

            @Override
            public String getType() {
                return "java.lang.String";
            }

            @Override
            public List<String> getAllowedValues() {
                ArrayList<String> allowedValues = new ArrayList<String>();
                for (DictionaryCommand command : this.dict) {
                    allowedValues.add(command.getCommandName());
                }
                return allowedValues;
            }

            @Override
            public String getDefaultValue() {
                return null;
            }
        }

        private static class RoutingCommandArgumentsArgument
        implements DictionaryArgument {
            private RoutingCommandArgumentsArgument() {
            }

            @Override
            public String getDescription() {
                return "The arguments for the command";
            }

            @Override
            public String getName() {
                return "arguments...";
            }

            @Override
            public String getSimpleType() {
                return "String";
            }

            @Override
            public String getType() {
                return "java.lang.String";
            }

            @Override
            public List<String> getAllowedValues() {
                return Collections.EMPTY_LIST;
            }

            @Override
            public String getDefaultValue() {
                return null;
            }
        }
    }

    private static class RoutingDictionary
    implements Dictionary {
        private final LinkedHashMap<String, DictionaryCommand> routeMap = new LinkedHashMap();
        private final RoutingDictionaryHelpGenerator helpGenerator = new RoutingDictionaryHelpGenerator(this.routeMap);
        private final Dictionary innerDictionary;
        private final RoutingDictionaryCompleter completer;
        private final String route;

        RoutingDictionary(String route, Dictionary dict) {
            this.routeMap.put(route, new RoutingCommand(route, dict));
            this.innerDictionary = dict;
            this.route = route;
            this.completer = new RoutingDictionaryCompleter(this);
        }

        RoutingCommand getRouteCommand(String route) {
            return (RoutingCommand)this.routeMap.get(route);
        }

        Dictionary getInnerDictionary() {
            return this.innerDictionary;
        }

        String getRoute() {
            return this.route;
        }

        @Override
        public boolean containsCommand(BasicCommand tc) {
            return this.routeMap.containsKey(tc.getCommand());
        }

        @Override
        public DictionaryCommand findCommand(BasicCommand tc) {
            return this.routeMap.get(tc.getCommand());
        }

        @Override
        public int size() {
            return this.routeMap.size();
        }

        @Override
        public Iterator<DictionaryCommand> iterator() {
            return this.routeMap.values().iterator();
        }

        @Override
        public DictionaryHelpGenerator getHelpGenerator() {
            return this.helpGenerator;
        }

        @Override
        public DictionaryCompleter getDictionaryCompleter() {
            return this.completer;
        }
    }

    private static class RoutingDictionaryCompleter
    implements DictionaryCompleter {
        private final DictionaryCompleter routingDictionaryCompleter;
        private final DictionaryCompleter innerDictionaryCompleter;
        private final String route;

        RoutingDictionaryCompleter(RoutingDictionary dict) {
            this.routingDictionaryCompleter = new DefaultDictionaryCompleter(dict);
            this.innerDictionaryCompleter = dict.getInnerDictionary().getDictionaryCompleter();
            this.route = dict.getRoute();
        }

        @Override
        public int complete(String buffer, int index, List<CharSequence> list) {
            boolean endsWithWhiteSpace;
            TokenizedCommand tc = new TokenizedCommand(buffer.substring(0, index));
            int argCount = tc.getArgumentCount();
            boolean bl = endsWithWhiteSpace = !tc.isEmpty() && Character.isWhitespace(buffer.charAt(index - 1));
            if (endsWithWhiteSpace) {
                ++argCount;
            }
            if (argCount > 1 && buffer.startsWith(this.route)) {
                if (this.innerDictionaryCompleter != null) {
                    int newIndex;
                    int extraIndex = this.route.length() + 1;
                    String newBuffer = buffer.substring(extraIndex);
                    int completionValue = this.innerDictionaryCompleter.complete(newBuffer, newIndex = index - extraIndex, list);
                    return completionValue == -1 ? completionValue : completionValue + this.route.length() + 1;
                }
            } else {
                int ret = this.routingDictionaryCompleter.complete(buffer, index, list);
                return ret;
            }
            return index;
        }
    }

    private static class RoutingDictionaryHelpGenerator
    implements DictionaryHelpGenerator {
        private final HashMap<String, DictionaryCommand> routeMap;

        public RoutingDictionaryHelpGenerator(HashMap<String, DictionaryCommand> routeMap) {
            this.routeMap = routeMap;
        }

        @Override
        public boolean hasHelp(DictionaryCommand command) {
            return command instanceof RoutingCommand && this.routeMap.containsValue(command);
        }

        @Override
        public String modifyHelpForCommand(DictionaryCommand command, String help, boolean compact) {
            help = "(t) " + help;
            if (!compact) {
                help = String.valueOf(help) + "Available commands: \n";
                help = String.valueOf(help) + DictionaryUtils.basicHelpForDictionary(((RoutingCommand)command).getDictionary(), "     ");
            }
            return help;
        }
    }
}

