/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.wattsup;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.drivers.ftdi.Ftdi;
import org.lsst.ccs.drivers.ftdi.FtdiException;
import org.lsst.ccs.drivers.wattsup.WattsUpException;

public class WattsUp {
    public static final int FLD_WATTS = 0;
    public static final int FLD_VOLTS = 1;
    public static final int FLD_AMPS = 2;
    public static final int FLD_WATT_HOURS = 3;
    public static final int FLD_COST = 4;
    public static final int FLD_WH_MONTH = 5;
    public static final int FLD_COST_MONTH = 6;
    public static final int FLD_WATTS_MAX = 7;
    public static final int FLD_VOLTS_MAX = 8;
    public static final int FLD_AMPS_MAX = 9;
    public static final int FLD_WATTS_MIN = 10;
    public static final int FLD_VOLTS_MIN = 11;
    public static final int FLD_AMPS_MIN = 12;
    public static final int FLD_POWER_FACTOR = 13;
    public static final int FLD_DUTY_CYCLE = 14;
    public static final int FLD_POWER_CYCLE = 15;
    public static final int FLD_FREQUENCY = 16;
    public static final int FLD_VOLT_AMPS = 17;
    public static final int N_FIELDS = 18;
    public static final int N_CAL_FIELDS = 48;
    public static final int MEM_OPT_SUSPEND = 0;
    public static final int MEM_OPT_OVERWRITE = 1;
    public static final int MEM_OPT_CONDENSE = 2;
    public static final int LOG_STA_SUSPENDED = 0;
    public static final int LOG_STA_INTERNAL = 1;
    public static final int LOG_STA_EXTERNAL = 2;
    public static final int VER_FLD_MODEL = 0;
    public static final int VER_FLD_MEMORY = 1;
    public static final int VER_FLD_HWMAJOR = 2;
    public static final int VER_FLD_HW_MINOR = 3;
    public static final int VER_FLD_FWMAJOR = 4;
    public static final int VER_FLD_FWMINOR = 5;
    public static final int VER_FLD_FWTSTAMP = 6;
    public static final int VER_FLD_CHECKSUM = 7;
    public static final int N_VER_FIELDS = 8;
    private static final int BAUD_RATE = 115200;
    private static final int READ_TIMEOUT = 2000;
    private static final int READ_INTERVAL = 1000;
    private static final int CHECK_INTERVAL = 1000;
    private static final String TIMEOUT_MSG = "Read timeout";
    private Reader reader;
    private final CheckPower checkPower;
    private Ftdi ftd = new Ftdi();
    private boolean open;
    private boolean powered;
    private ArrayBlockingQueue replyQ = new ArrayBlockingQueue(10);
    private ArrayBlockingQueue closeQ = new ArrayBlockingQueue(1);
    private int nDataSent;
    private Listener listener;

    public WattsUp() {
        this.checkPower = new CheckPower();
        this.checkPower.setDaemon(true);
        this.checkPower.start();
    }

    public void open(int index, String serial) throws WattsUpException {
        this.open(null, index, serial);
    }

    public void open(String node, int index, String serial) throws WattsUpException {
        if (this.open) {
            throw new WattsUpException("Device already open");
        }
        try {
            this.ftd.open(node, index, serial);
            this.ftd.setBaudrate(115200);
            this.ftd.setDataCharacteristics(8, 0, 0);
            this.ftd.setTimeouts(1000, 0);
        }
        catch (FtdiException e) {
            throw new WattsUpException(e.getMessage());
        }
        this.open = true;
        this.nDataSent = 0;
        this.replyQ.clear();
        this.closeQ.clear();
        this.reader = new Reader();
        this.reader.setDaemon(true);
        this.reader.start();
    }

    public void close() throws WattsUpException {
        this.checkOpen();
        this.open = false;
        this.powered = false;
        Object excp = null;
        try {
            excp = this.closeQ.take();
        }
        catch (InterruptedException interruptedException) {}
        if (excp instanceof WattsUpException) {
            throw (WattsUpException)excp;
        }
    }

    public void addListener(Listener listener) {
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }

    public synchronized int getLoggedFields() throws WattsUpException {
        this.checkOpen();
        this.send("#C,R,0;");
        String[] reply = this.receive("c", 18);
        int mask = 0;
        int j = 0;
        while (j < 18) {
            if (reply[j].equals("1")) {
                mask |= 1 << j;
            }
            ++j;
        }
        return mask;
    }

    public synchronized int setLoggedFields(int mask) throws WattsUpException {
        this.checkOpen();
        String cmnd = "#C,W,18";
        int j = 0;
        while (j < 18) {
            cmnd = String.valueOf(cmnd) + "," + ((mask & 1 << j) != 0 ? "1" : "0");
            ++j;
        }
        cmnd = String.valueOf(cmnd) + ';';
        this.send(cmnd);
        return Integer.valueOf(this.receive("n", 1)[0]);
    }

    public synchronized int[] getCalibrationData() throws WattsUpException {
        this.checkOpen();
        this.send("#F,R,0;");
        String[] reply = this.receive("f", 48);
        int[] values = new int[48];
        int j = 0;
        while (j < 48) {
            values[j] = (int)Long.valueOf(reply[j]).longValue();
            ++j;
        }
        return values;
    }

    public synchronized String[] getHeaderRecord() throws WattsUpException {
        this.checkOpen();
        this.send("#H,R,0;");
        return this.receive("h", 18);
    }

    public synchronized int getLoggedData() throws WattsUpException {
        this.checkOpen();
        this.send("#D,R,0;");
        this.receive("n", 3);
        int count = this.nDataSent;
        while (true) {
            try {
                return Integer.valueOf(this.receive("l", 2)[1]);
            }
            catch (WattsUpException e) {
                if (this.nDataSent == count) {
                    throw e;
                }
                count = this.nDataSent;
                continue;
            }
            break;
        }
    }

    public synchronized int setInternalLogging(int interval) throws WattsUpException {
        this.checkOpen();
        this.send("#L,W,3,_,I," + interval + ";");
        return Integer.valueOf(this.receive("s", 3)[1]);
    }

    public void setExternalLogging(int interval) throws WattsUpException {
        this.checkOpen();
        this.send("#L,W,3,_,E," + interval + ";");
    }

    public synchronized int getRecordLimit() throws WattsUpException {
        this.checkOpen();
        this.send("#N,R,0;");
        return Integer.valueOf(this.receive("n", 1)[0]);
    }

    public synchronized int getFullOption() throws WattsUpException {
        this.checkOpen();
        this.send("#O,R,0;");
        return Integer.valueOf(this.receive("o", 1)[0]);
    }

    public void setFullOption(int option) throws WattsUpException {
        this.checkOpen();
        this.send("#O,W,1," + option + ";");
    }

    public void resetMemory() throws WattsUpException {
        this.checkOpen();
        this.send("#R,W,0;");
    }

    public synchronized int getLoggingInterval() throws WattsUpException {
        this.checkOpen();
        this.send("#S,R,0;");
        return Integer.valueOf(this.receive("s", 3)[1]);
    }

    public synchronized int getLoggingState() throws WattsUpException {
        this.checkOpen();
        this.send("#S,R,0;");
        return Integer.valueOf(this.receive("s", 3)[2]);
    }

    public void setLoggingInterval(int interval) throws WattsUpException {
        this.checkOpen();
        this.send("#S,W,2,_," + interval + ";");
    }

    public synchronized float getUserRate() throws WattsUpException {
        this.checkOpen();
        this.send("#U,R,0;");
        return Float.valueOf(this.receive("u", 3)[0]).floatValue() / 1000.0f;
    }

    public synchronized int getUserThreshold() throws WattsUpException {
        this.checkOpen();
        this.send("#U,R,0;");
        return Integer.valueOf(this.receive("u", 3)[1]);
    }

    public synchronized boolean getUserEuro() throws WattsUpException {
        this.checkOpen();
        this.send("#U,R,0;");
        return !this.receive("u", 3)[2].equals("0");
    }

    public void setUserParameters(float rate, int threshold, boolean euro) throws WattsUpException {
        this.checkOpen();
        this.send("#U,W,3," + (int)((double)(1000.0f * rate) + 0.5) + "," + threshold + "," + (euro ? "1" : "0") + ";");
    }

    public synchronized String[] getVersionData() throws WattsUpException {
        this.checkOpen();
        this.send("#V,R,0;");
        return this.receive("v", 8);
    }

    public void restart() throws WattsUpException {
        this.checkOpen();
        this.send("#V,W,0;");
    }

    private void send(String cmnd) throws WattsUpException {
        try {
            this.ftd.write(cmnd.getBytes());
        }
        catch (FtdiException e) {
            throw new WattsUpException(e.getMessage());
        }
    }

    private String[] receive(String id, int nFlds) throws WattsUpException {
        return this.receive(id, nFlds, 2000);
    }

    private String[] receive(String id, int nFlds, int timeout) throws WattsUpException {
        Object reply;
        String[] head;
        do {
            reply = null;
            try {
                reply = this.replyQ.poll(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
            if (reply == null) {
                throw new WattsUpException(TIMEOUT_MSG);
            }
            if (!(reply instanceof WattsUpException)) continue;
            throw (WattsUpException)reply;
        } while ((head = ((String)reply).split(",", 4)).length < 4 || !head[0].equals(id) || Integer.valueOf(head[2]) != nFlds);
        return head.length < 4 ? null : head[3].split(",");
    }

    private void sendListener(String reply) {
        ++this.nDataSent;
        if (this.listener == null) {
            return;
        }
        String[] fields = reply.split(",");
        float[] values = new float[18];
        int j = 0;
        while (j < 18) {
            String field = fields[j + 3];
            if (field.equals("_")) {
                values[j] = 0.0f;
            } else {
                int temp = Integer.valueOf(field);
                values[j] = j == 2 || j == 9 || j == 12 || j == 4 || j == 6 ? (float)temp / 1000.0f : (j == 5 || j == 15 ? (float)temp : (j == 13 || j == 14 ? (float)temp / 100.0f : (float)temp / 10.0f));
            }
            ++j;
        }
        this.listener.processData(values);
    }

    private void checkOpen() throws WattsUpException {
        if (!this.open) {
            throw new WattsUpException("Device not open");
        }
    }

    static /* synthetic */ Ftdi access$1(WattsUp wattsUp) {
        return wattsUp.ftd;
    }

    static /* synthetic */ void access$3(WattsUp wattsUp, String string) {
        wattsUp.sendListener(string);
    }

    static /* synthetic */ ArrayBlockingQueue access$4(WattsUp wattsUp) {
        return wattsUp.replyQ;
    }

    static /* synthetic */ void access$5(WattsUp wattsUp, boolean bl) {
        wattsUp.open = bl;
    }

    static /* synthetic */ ArrayBlockingQueue access$7(WattsUp wattsUp) {
        return wattsUp.closeQ;
    }

    private class CheckPower
    extends Thread {
        private CheckPower() {
        }

        @Override
        public void run() {
            while (true) {
                block8: {
                    if (WattsUp.this.open) {
                        try {
                            WattsUp.this.getRecordLimit();
                            if (!WattsUp.this.powered) {
                                WattsUp.this.powered = true;
                                if (WattsUp.this.listener != null) {
                                    WattsUp.this.listener.setPowered(WattsUp.this.powered);
                                }
                            }
                        }
                        catch (WattsUpException e) {
                            if (!e.getMessage().equals(WattsUp.TIMEOUT_MSG) || !WattsUp.this.powered) break block8;
                            WattsUp.this.powered = false;
                            if (WattsUp.this.listener == null) break block8;
                            WattsUp.this.listener.setPowered(WattsUp.this.powered);
                        }
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    public static interface Listener {
        public void processData(float[] var1);

        public void setPowered(boolean var1);

        public void setClosed();
    }

    private class Reader
    extends Thread {
        private final byte HASH = (byte)35;
        private final byte SEMIC = (byte)59;
        private final byte DATA_ID = (byte)100;
        private int buffCurr;
        private int recdStart = -1;
        private int recdEnd = -1;
        private int recdCurr;
        private Exception excp;

        private Reader() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block21: {
                buff = new byte[1024];
                while (true) {
                    leng = 0;
                    try {
                        while (WattsUp.access$0(WattsUp.this) && leng == 0) {
                            leng = WattsUp.access$1(WattsUp.this).read(buff, this.buffCurr, 1);
                        }
                        if (!WattsUp.access$0(WattsUp.this)) break;
                        this.buffCurr += leng;
                        leng = WattsUp.access$1(WattsUp.this).getQueueStatus();
                        if (leng > 0) {
                            maxLeng = buff.length - this.buffCurr - 1;
                            if (leng > maxLeng) {
                                leng = maxLeng;
                            }
                            leng = WattsUp.access$1(WattsUp.this).read(buff, this.buffCurr, leng);
                            this.buffCurr += leng;
                        }
                        ** GOTO lbl40
                    }
                    catch (FtdiException e) {
                        this.excp = e;
                        break;
                    }
                    {
                        if (buff[this.recdCurr++] == 35) {
                            this.recdStart = this.recdCurr;
                        }
                        do {
                            if (this.recdStart < 0 && this.recdCurr < this.buffCurr) continue block6;
                            while (this.recdEnd < 0 && this.recdCurr < this.buffCurr) {
                                if (buff[this.recdCurr++] != 59) continue;
                                this.recdEnd = this.recdCurr - 1;
                            }
                            if (this.recdStart < 0 || this.recdEnd < 0) break block6;
                            recdId = buff[this.recdStart];
                            if (recdId != 100 || WattsUp.access$2(WattsUp.this) != null) {
                                record = new String(buff, this.recdStart, this.recdEnd - this.recdStart);
                                if (recdId == 100) {
                                    WattsUp.access$3(WattsUp.this, record);
                                } else {
                                    WattsUp.access$4(WattsUp.this).offer(record);
                                }
                            }
                            this.recdStart = -1;
                            this.recdEnd = -1;
lbl40:
                            // 2 sources

                        } while (this.recdCurr < this.buffCurr);
                    }
                    if (this.recdStart < 0) {
                        this.buffCurr = 0;
                        this.recdCurr = 0;
                        continue;
                    }
                    leng = this.buffCurr - this.recdStart;
                    System.arraycopy(buff, this.recdStart, buff, 0, leng);
                    this.buffCurr = leng;
                    this.recdStart = 0;
                    this.recdCurr = leng;
                }
                try {
                    WattsUp.access$1(WattsUp.this).close();
                }
                catch (FtdiException e) {
                    if (this.excp != null) break block21;
                    this.excp = e;
                }
            }
            if (WattsUp.access$0(WattsUp.this)) {
                WattsUp.access$5(WattsUp.this, false);
                WattsUp.access$6(WattsUp.this, false);
                WattsUp.access$4(WattsUp.this).clear();
                WattsUp.access$4(WattsUp.this).offer(new WattsUpException(this.excp.getMessage()));
                if (WattsUp.access$2(WattsUp.this) != null) {
                    WattsUp.access$2(WattsUp.this).setClosed();
                }
            } else if (this.excp == null) {
                WattsUp.access$7(WattsUp.this).offer(new Object());
            } else {
                WattsUp.access$7(WattsUp.this).offer(new WattsUpException(this.excp.getMessage()));
            }
        }
    }
}

