/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.wattsup;

import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.drivers.wattsup.WattsUpException;
import org.lsst.ccs.utilities.sa.CmndProcess;

public class TestWattsUp
implements CmndProcess.Dispatch,
WattsUp.Listener {
    private static final int CMD_OPEN = 0;
    private static final int CMD_CLOSE = 1;
    private static final int CMD_FLDSHOW = 2;
    private static final int CMD_CALSHOW = 3;
    private static final int CMD_HDRSHOW = 4;
    private static final int CMD_LIMSHOW = 5;
    private static final int CMD_MEMSHOW = 6;
    private static final int CMD_LOGSHOW = 7;
    private static final int CMD_PARMSHOW = 8;
    private static final int CMD_VERSHOW = 9;
    private static final int CMD_FLDSET = 10;
    private static final int CMD_LOGSET = 11;
    private static final int CMD_MEMSET = 12;
    private static final int CMD_RESET = 13;
    private static final int CMD_INTSET = 14;
    private static final int CMD_PARMSET = 15;
    private static final int CMD_RESTART = 16;
    private static final int CMD_DATASHOW = 17;
    private static final int CMD_LISTEN = 18;
    private static final int NUM_CMDS = 19;
    private static final String[] helpOpen = new String[]{"Open meter connection", "open [<index>] [<serial>] [<node>]", "index   The index of the meter in the list of matching FTDI devices", "        (default 0)", "serial  The serial number fragment to be matched (default none)", "node    The node where the meter is attached (default local)"};
    private static final String[] helpClose = new String[]{"Close meter connection", "close"};
    private static final String[] helpListen = new String[]{"Turn the event listener on or off", "listen <action>", "action  The action to perform: 'on' or 'off'"};
    private static final String[] helpFldset = new String[]{"Set the fields to be logged", "fldset <mask>", "mask  Bit mask of the fields to be logged"};
    private static final String[] helpFldshow = new String[]{"Display the fields being logged", "fldshow"};
    private static final String[] helpCalshow = new String[]{"Display calibration data", "calshow"};
    private static final String[] helpHdrshow = new String[]{"Display header record", "hdrshow"};
    private static final String[] helpLimshow = new String[]{"Display the record limit", "limshow"};
    private static final String[] helpMemset = new String[]{"Set the memory-full option", "memset <option>", "option  The memory-full option: 'suspend', 'overwrite' or 'condense'"};
    private static final String[] helpMemshow = new String[]{"Display the memory-full option", "memshow"};
    private static final String[] helpIntset = new String[]{"Set the logging interval", "intset <interval>", "interval  The logging interval (secs)"};
    private static final String[] helpLogset = new String[]{"Set the logging type and interval", "logset <type> <interval>", "type      The logging type: 'internal' or 'external'", "interval  The logging interval (secs)"};
    private static final String[] helpLogshow = new String[]{"Display the logging state", "logshow"};
    private static final String[] helpParmset = new String[]{"Set the user parameters", "parmset <rate> <thresh> [<curr>]", "rate    The electricity rate (currency units / KWH)", "thresh  The duty cycle threshold (watts)", "curr    The currency: 'dollar' (default) or 'euro'"};
    private static final String[] helpParmshow = new String[]{"Display the user parameters", "parmshow"};
    private static final String[] helpVershow = new String[]{"Display the version data", "vershow"};
    private static final String[] helpReset = new String[]{"Reset (clear) the logging memory", "reset"};
    private static final String[] helpRestart = new String[]{"Restart the meter", "restart"};
    private static final String[] helpDatashow = new String[]{"Read and display all the stored data", "datashow [<level>]", "level    The display level: 'detail' (default) or 'summary' (show only", "         the record count)"};
    private static final CmndProcess.Lookup onoffWords = new CmndProcess.Lookup(2);
    private static final CmndProcess.Lookup memWords;
    private static final CmndProcess.Lookup logWords;
    private static final CmndProcess.Lookup logshWords;
    private static final CmndProcess.Lookup currWords;
    private static final CmndProcess.Lookup dataWords;
    private static final CmndProcess.Command cmnd;
    private static final PrintStream out;
    private final CmndProcess proc = new CmndProcess();
    private WattsUp wtu;
    private int fieldMask;
    private int dataCount;
    private boolean devOpen;
    private boolean dataSumm;
    private boolean listening;
    private static final byte[] flags;

    static {
        onoffWords.add("on", 1);
        onoffWords.add("off", 0);
        memWords = new CmndProcess.Lookup(3);
        memWords.add("suspend", 0);
        memWords.add("overwrite", 1);
        memWords.add("condense", 2);
        logWords = new CmndProcess.Lookup(2);
        logWords.add("external", 1);
        logWords.add("internal", 0);
        logshWords = new CmndProcess.Lookup(3);
        logshWords.add("suspended", 0);
        logshWords.add("internal", 1);
        logshWords.add("external", 2);
        currWords = new CmndProcess.Lookup(2);
        currWords.add("euro", 1);
        currWords.add("dollar", 0);
        dataWords = new CmndProcess.Lookup(2);
        dataWords.add("summary", 1);
        dataWords.add("detail", 0);
        cmnd = new CmndProcess.Command(19);
        cmnd.add("open", 0, helpOpen, "iss", new CmndProcess.Lookup[0]);
        cmnd.add("close", 1, helpClose, "", new CmndProcess.Lookup[0]);
        cmnd.add("listen", 18, helpListen, "K", new CmndProcess.Lookup[]{onoffWords});
        cmnd.add("fldset", 10, helpFldset, "I", new CmndProcess.Lookup[0]);
        cmnd.add("fldshow", 2, helpFldshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("calshow", 3, helpCalshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("hdrshow", 4, helpHdrshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("limshow", 5, helpLimshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("memset", 12, helpMemset, "K", new CmndProcess.Lookup[]{memWords});
        cmnd.add("memshow", 6, helpMemshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("intset", 14, helpIntset, "I", new CmndProcess.Lookup[0]);
        cmnd.add("logset", 11, helpLogset, "KI", new CmndProcess.Lookup[]{logWords});
        cmnd.add("logshow", 7, helpLogshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("parmset", 15, helpParmset, "FIk", new CmndProcess.Lookup[]{currWords});
        cmnd.add("parmshow", 8, helpParmshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("vershow", 9, helpVershow, "", new CmndProcess.Lookup[0]);
        cmnd.add("reset", 13, helpReset, "", new CmndProcess.Lookup[0]);
        cmnd.add("restart", 16, helpRestart, "", new CmndProcess.Lookup[0]);
        cmnd.add("datashow", 17, helpDatashow, "k", new CmndProcess.Lookup[]{dataWords});
        out = System.out;
        flags = new byte[]{124, 47, 45, 92};
    }

    public static void main(String[] args) {
        new TestWattsUp().run();
        System.exit(0);
    }

    public void run() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        try {
            String line;
            this.wtu = new WattsUp();
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
            if (this.devOpen) {
                this.wtu.close();
            }
        }
        catch (Exception e) {
            out.println(e);
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 0: {
                    this.procOpen(found, args);
                    break;
                }
                case 1: {
                    this.procClose(found, args);
                    break;
                }
                case 18: {
                    this.procListen(found, args);
                    break;
                }
                case 10: {
                    this.procFldset(found, args);
                    break;
                }
                case 2: {
                    this.procFldshow(found, args);
                    break;
                }
                case 3: {
                    this.procCalshow(found, args);
                    break;
                }
                case 4: {
                    this.procHdrshow(found, args);
                    break;
                }
                case 5: {
                    this.procLimshow(found, args);
                    break;
                }
                case 12: {
                    this.procMemset(found, args);
                    break;
                }
                case 6: {
                    this.procMemshow(found, args);
                    break;
                }
                case 14: {
                    this.procIntset(found, args);
                    break;
                }
                case 11: {
                    this.procLogset(found, args);
                    break;
                }
                case 7: {
                    this.procLogshow(found, args);
                    break;
                }
                case 15: {
                    this.procParmset(found, args);
                    break;
                }
                case 8: {
                    this.procParmshow(found, args);
                    break;
                }
                case 9: {
                    this.procVershow(found, args);
                    break;
                }
                case 13: {
                    this.procReset(found, args);
                    break;
                }
                case 16: {
                    this.procRestart(found, args);
                    break;
                }
                case 17: {
                    this.procDatashow(found, args);
                    break;
                }
                default: {
                    out.println("Command not fully implemented");
                    break;
                }
            }
        }
        catch (WattsUpException e) {
            out.println(e);
        }
        return true;
    }

    private void procOpen(int found, Object[] args) throws WattsUpException {
        int index = (found & 1) != 0 ? (Integer)args[0] : 0;
        String serial = (found & 2) != 0 ? (String)args[1] : null;
        String node = (found & 4) != 0 ? (String)args[2] : null;
        this.wtu.open(node, index, serial);
        this.devOpen = true;
        this.fieldMask = this.wtu.getLoggedFields();
    }

    private void procClose(int found, Object[] args) throws WattsUpException {
        this.wtu.close();
        this.devOpen = false;
    }

    private void procListen(int found, Object[] args) {
        boolean bl = this.listening = (Integer)args[0] != 0;
        if (this.listening) {
            this.wtu.addListener(this);
        } else {
            this.wtu.removeListener();
        }
    }

    private void procFldset(int found, Object[] args) throws WattsUpException {
        this.fieldMask = (Integer)args[0];
        int limit = this.wtu.setLoggedFields(this.fieldMask);
        out.println("Record limit = " + limit);
    }

    private void procFldshow(int found, Object[] args) throws WattsUpException {
        out.format("Value = %08x\n", this.wtu.getLoggedFields());
    }

    private void procCalshow(int found, Object[] args) throws WattsUpException {
        this.showIntegers(this.wtu.getCalibrationData());
    }

    private void procHdrshow(int found, Object[] args) throws WattsUpException {
        this.showStrings(this.wtu.getHeaderRecord());
    }

    private void procLimshow(int found, Object[] args) throws WattsUpException {
        out.println("Record limit = " + this.wtu.getRecordLimit());
    }

    private void procMemset(int found, Object[] args) throws WattsUpException {
        this.wtu.setFullOption((Integer)args[0]);
    }

    private void procMemshow(int found, Object[] args) throws WattsUpException {
        int option = this.wtu.getFullOption();
        out.format("Memory full option = %s (%s)\n", option, memWords.decode(option));
    }

    private void procIntset(int found, Object[] args) throws WattsUpException {
        this.wtu.setLoggingInterval((Integer)args[0]);
    }

    private void procLogset(int found, Object[] args) throws WattsUpException {
        if ((Integer)args[0] == 0) {
            int intvl = this.wtu.setInternalLogging((Integer)args[1]);
            out.println("Resulting interval = " + intvl);
        } else {
            this.dataSumm = false;
            this.wtu.setExternalLogging((Integer)args[1]);
            if (!this.listening) {
                out.println("Turn listener on for data display");
            }
        }
    }

    private void procLogshow(int found, Object[] args) throws WattsUpException {
        int state = this.wtu.getLoggingState();
        out.format("Logging interval = %s, logging state = %s (%s)\n", this.wtu.getLoggingInterval(), state, logshWords.decode(state));
    }

    private void procParmset(int found, Object[] args) throws WattsUpException {
        boolean euro = (found & 4) != 0 && (Integer)args[2] != 0;
        this.wtu.setUserParameters(((Float)args[0]).floatValue(), (Integer)args[1], euro);
    }

    private void procParmshow(int found, Object[] args) throws WattsUpException {
        out.format("Rate = %.3f, threshold = %s, euro = %s\n", Float.valueOf(this.wtu.getUserRate()), this.wtu.getUserThreshold(), this.wtu.getUserEuro());
    }

    private void procVershow(int found, Object[] args) throws WattsUpException {
        this.showStrings(this.wtu.getVersionData());
    }

    private void procReset(int found, Object[] args) throws WattsUpException {
        this.wtu.resetMemory();
    }

    private void procRestart(int found, Object[] args) throws WattsUpException {
        this.wtu.restart();
    }

    private void procDatashow(int found, Object[] args) throws WattsUpException {
        this.dataSumm = (found & 1) != 0 && (Integer)args[0] != 0;
        this.dataCount = 0;
        if (!this.listening) {
            out.println("Turn listener on for data display");
        }
        int interval = this.wtu.getLoggedData();
        out.println("Record count = " + this.dataCount + ", logging interval = " + interval);
        this.dataSumm = false;
    }

    @Override
    public void setPowered(boolean on) {
        out.println("Device powered " + (on ? "on" : "off"));
    }

    @Override
    public void setClosed() {
        out.println("Device connection closed");
        this.devOpen = false;
    }

    @Override
    public void processData(float[] data) {
        ++this.dataCount;
        if (this.dataSumm) {
            if ((this.dataCount & 7) == 0) {
                byte[] flag = new byte[]{flags[this.dataCount >> 3 & 3], 8};
                out.write(flag, 0, 2);
            }
        } else {
            this.showFloats(data, this.fieldMask);
        }
    }

    private void showStrings(String[] value) {
        out.print("Values =");
        int posn = 8;
        int j = 0;
        while (j < value.length) {
            String sValue = " " + value[j];
            if ((posn += sValue.length()) > 80) {
                out.print("\n        ");
                posn = 8 + sValue.length();
            }
            out.print(sValue);
            ++j;
        }
        out.println();
    }

    private void showIntegers(int[] value) {
        out.print("Values =");
        int posn = 8;
        int j = 0;
        while (j < value.length) {
            String sValue = " " + value[j];
            if ((posn += sValue.length()) > 80) {
                out.print("\n        ");
                posn = 8 + sValue.length();
            }
            out.print(sValue);
            ++j;
        }
        out.println();
    }

    private void showFloats(float[] value, int mask) {
        out.print("Values =");
        int posn = 8;
        int j = 0;
        while (j < value.length) {
            if ((mask & 1 << j) != 0) {
                String sValue = " " + value[j];
                if ((posn += sValue.length()) > 80) {
                    out.print("\n        ");
                    posn = 8 + sValue.length();
                }
                out.print(sValue);
            }
            ++j;
        }
        out.println();
    }
}

