/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.jars;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Manifest;

public class CommonResources {
    public static final URL[] URL_ARRAY_MODEL = new URL[0];

    public static URL[] getURLsFrom(ClassLoader loader, String commonResourceName) {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> enumURL = loader.getResources(commonResourceName);
            while (enumURL.hasMoreElements()) {
                list.add(enumURL.nextElement());
            }
        }
        catch (IOException iOException) {}
        return list.toArray(URL_ARRAY_MODEL);
    }

    public static URL[] getURLsFrom(String commonResourceName) {
        return CommonResources.getURLsFrom(Thread.currentThread().getContextClassLoader(), commonResourceName);
    }

    public static URL[] getURLsFor(Object obj, String commonResourceName) {
        String[] urlNames;
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        ArrayList<URL> list = new ArrayList<URL>();
        ClassLoader loader = clazz.getClassLoader();
        URL[] allResources = CommonResources.getURLsFrom(loader, commonResourceName);
        String[] stringArray = urlNames = CommonResources.getClassURLNamesFor(clazz);
        int n = urlNames.length;
        int n2 = 0;
        while (n2 < n) {
            String urlName = stringArray[n2];
            URL[] uRLArray = allResources;
            int n3 = allResources.length;
            int n4 = 0;
            while (n4 < n3) {
                URL urlResource = uRLArray[n4];
                if (urlResource.toString().startsWith(urlName)) {
                    list.add(urlResource);
                }
                ++n4;
            }
            ++n2;
        }
        return list.toArray(URL_ARRAY_MODEL);
    }

    public static String[] getClassURLNamesFor(Object obj) {
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        String classNamePath = String.valueOf(clazz.getCanonicalName().replace('.', '/')) + ".class";
        ClassLoader loader = clazz.getClassLoader();
        URL[] classRepositories = CommonResources.getURLsFrom(loader, classNamePath);
        String[] res = new String[classRepositories.length];
        int ix = 0;
        while (ix < classRepositories.length) {
            String urlName = classRepositories[ix].toString().replace(classNamePath, "");
            res[ix] = urlName.substring(0, urlName.length() - 1);
            ++ix;
        }
        return res;
    }

    public static Properties getPropertiesFrom(URL url) {
        Properties props = new Properties();
        try {
            InputStream is = url.openStream();
            props.load(is);
        }
        catch (Exception exception) {}
        return props;
    }

    public static String getResourceContainer(URL url, String commonResourceName) {
        int lastSlash;
        String path = url.getPath();
        int idx = path.lastIndexOf(commonResourceName);
        if (idx < 0) {
            return null;
        }
        String pathWithoutResource = path.substring(0, idx - 1);
        String res = pathWithoutResource.substring((lastSlash = pathWithoutResource.lastIndexOf(47)) + 1);
        res = res.endsWith("!") ? res.substring(0, res.length() - 1) : pathWithoutResource;
        return res;
    }

    public static Manifest getManifestFor(Object obj) {
        URL[] jarURLs = CommonResources.getURLsFor(obj, "META-INF/MANIFEST.MF");
        if (jarURLs.length > 0) {
            URL jarURL = jarURLs[0];
            try {
                InputStream is = jarURL.openStream();
                Manifest res = new Manifest(is);
                return res;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }
}

