/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.wattsup;

import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.ftdi.Ftdi;
import org.lsst.ccs.drivers.ftdi.FtdiException;

public class TalkWatts {
    private static final PrintStream out = System.out;
    private final Thread readW = new Thread(new Reader());
    private Ftdi ftd = new Ftdi();
    private int nRead = 0;
    private int nByte = 0;
    private boolean open;

    public static void main(String[] args) throws Exception {
        try {
            int index = args.length >= 1 ? Integer.decode(args[0]) : 0;
            String serial = args.length >= 2 ? args[1] : null;
            new TalkWatts().run(index, serial);
        }
        catch (NumberFormatException numberFormatException) {
            out.println("Invalid device index");
        }
        System.exit(0);
    }

    public void run(int index, String serial) throws Exception {
        String line;
        this.ftd.open(index, serial);
        this.ftd.setBaudrate(115200);
        this.ftd.setDataCharacteristics(8, 0, 0);
        this.open = true;
        this.readW.setDaemon(true);
        this.readW.start();
        ConsoleReader readC = new ConsoleReader();
        while ((line = readC.readLine("")) != null) {
            if (line.equals("")) {
                out.format("#reads: %s; #bytes: %s\n", this.nRead, this.nByte);
                continue;
            }
            this.ftd.write(line.getBytes());
        }
        this.open = false;
        this.ftd.close();
    }

    private class Reader
    implements Runnable {
        byte[] data = new byte[1024];

        private Reader() {
        }

        @Override
        public void run() {
            while (true) {
                int leng;
                try {
                    leng = TalkWatts.this.ftd.read(this.data, 0, 1);
                    int nread = TalkWatts.this.ftd.getQueueStatus();
                    if (nread > this.data.length - leng) {
                        nread = this.data.length - leng;
                    }
                    if (!TalkWatts.this.open) break;
                    leng += TalkWatts.this.ftd.read(this.data, leng, nread);
                }
                catch (FtdiException e) {
                    if (!TalkWatts.this.open) break;
                    out.println(e);
                    break;
                }
                out.write(this.data, 0, leng);
                TalkWatts talkWatts = TalkWatts.this;
                talkWatts.nRead = talkWatts.nRead + 1;
                TalkWatts talkWatts2 = TalkWatts.this;
                talkWatts2.nByte = talkWatts2.nByte + leng;
            }
        }
    }
}

