/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.wattsup;

import gnu.io.SerialPort;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.utilities.sa.CmndProcess;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestWattsUp
implements CmndProcess.Dispatch,
WattsUp.Listener {
    private static final int CMD_OPEN = 0;
    private static final int CMD_CLOSE = 1;
    private static final int CMD_FLDSHOW = 2;
    private static final int CMD_CALSHOW = 3;
    private static final int CMD_HDRSHOW = 4;
    private static final int CMD_LIMSHOW = 5;
    private static final int CMD_MEMSHOW = 6;
    private static final int CMD_LOGSHOW = 7;
    private static final int CMD_PARMSHOW = 8;
    private static final int CMD_VERSHOW = 9;
    private static final int CMD_FLDSET = 10;
    private static final int CMD_LOGSET = 11;
    private static final int CMD_MEMSET = 12;
    private static final int CMD_RESET = 13;
    private static final int CMD_INTSET = 14;
    private static final int CMD_PARMSET = 15;
    private static final int CMD_RESTART = 16;
    private static final int CMD_DATASHOW = 17;
    private static final int CMD_PORTSHOW = 18;
    private static final int NUM_CMDS = 19;
    private static final String[] helpOpen = new String[]{"Open device connection", "open [<device>]", "device  The name of the serial port to connect to"};
    private static final String[] helpClose = new String[]{"Close device connection", "close"};
    private static final String[] helpFldset = new String[]{"Set the fields to be logged", "fldset <mask>", "mask  Bit mask of the fields to be logged"};
    private static final String[] helpFldshow = new String[]{"Display the fields being logged", "fldshow"};
    private static final String[] helpCalshow = new String[]{"Display calibration data", "calshow"};
    private static final String[] helpHdrshow = new String[]{"Display header record", "hdrshow"};
    private static final String[] helpLimshow = new String[]{"Display the record limit", "limshow"};
    private static final String[] helpMemset = new String[]{"Set the memory-full option", "memset <option>", "option  The memory-full option"};
    private static final String[] helpMemshow = new String[]{"Display the memory full option", "memshow"};
    private static final String[] helpLogset = new String[]{"Set the logging type and interval", "logset <type> <interval>", "type      The logging type: i = internal, e = external", "interval  The logging interval (secs)"};
    private static final String[] helpIntset = new String[]{"Set the logging interval", "intset <interval>", "interval  The logging interval (secs)"};
    private static final String[] helpLogshow = new String[]{"Display the logging state", "logshow"};
    private static final String[] helpParmset = new String[]{"Set the user parameters", "parmset <rate> <thresh> [<euro>]", "rate    The electricity rate (currency units / KWH)", "thresh  The duty cycle threshold (watts)", "euro    If non-zero, currency is euros, not dollars"};
    private static final String[] helpParmshow = new String[]{"Display the user parameters", "parmshow"};
    private static final String[] helpVershow = new String[]{"Display the version data", "vershow"};
    private static final String[] helpReset = new String[]{"Reset (clear) the logging memory", "reset"};
    private static final String[] helpRestart = new String[]{"Restart the meter", "restart"};
    private static final String[] helpDatashow = new String[]{"Read and display all the stored data", "datashow <summary>", "summary  If present and non-zero, show only the record count"};
    private static final String[] helpPortshow = new String[]{"Show the state of the serial port being used", "portshow"};
    private static final CmndProcess.Command cmnd = new CmndProcess.Command(19);
    private final Output out = new ConsOut();
    private final CmndProcess proc = new CmndProcess();
    private WattsUp wtu;
    private int fieldMask;
    private int dataCount;
    private boolean devOpen;
    private boolean dataSumm;
    private static final byte[] flags;

    static {
        cmnd.add("open", 0, helpOpen, "s", new CmndProcess.Lookup[0]);
        cmnd.add("close", 1, helpClose, "", new CmndProcess.Lookup[0]);
        cmnd.add("fldshow", 2, helpFldshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("calshow", 3, helpCalshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("hdrshow", 4, helpHdrshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("limshow", 5, helpLimshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("memshow", 6, helpMemshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("logshow", 7, helpLogshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("parmshow", 8, helpParmshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("vershow", 9, helpVershow, "", new CmndProcess.Lookup[0]);
        cmnd.add("fldset", 10, helpFldset, "I", new CmndProcess.Lookup[0]);
        cmnd.add("logset", 11, helpLogset, "SI", new CmndProcess.Lookup[0]);
        cmnd.add("memset", 12, helpMemset, "I", new CmndProcess.Lookup[0]);
        cmnd.add("reset", 13, helpReset, "", new CmndProcess.Lookup[0]);
        cmnd.add("intset", 14, helpIntset, "I", new CmndProcess.Lookup[0]);
        cmnd.add("parmset", 15, helpParmset, "FIi", new CmndProcess.Lookup[0]);
        cmnd.add("restart", 16, helpRestart, "", new CmndProcess.Lookup[0]);
        cmnd.add("datashow", 17, helpDatashow, "i", new CmndProcess.Lookup[0]);
        cmnd.add("portshow", 18, helpPortshow, "", new CmndProcess.Lookup[0]);
        flags = new byte[]{124, 47, 45, 92};
    }

    public static void main(String[] args) {
        new TestWattsUp().run();
        System.exit(0);
    }

    public void run() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        try {
            String line;
            this.wtu = new WattsUp();
            this.wtu.addListener(this);
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
        }
        catch (Exception e) {
            this.out.println((Object)e);
        }
        if (this.devOpen) {
            this.wtu.close();
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        switch (code) {
            case 0: {
                this.procOpen(found, args);
                break;
            }
            case 1: {
                this.procClose(found, args);
                break;
            }
            case 10: {
                this.procFldset(found, args);
                break;
            }
            case 2: {
                this.procFldshow(found, args);
                break;
            }
            case 3: {
                this.procCalshow(found, args);
                break;
            }
            case 4: {
                this.procHdrshow(found, args);
                break;
            }
            case 5: {
                this.procLimshow(found, args);
                break;
            }
            case 12: {
                this.procMemset(found, args);
                break;
            }
            case 6: {
                this.procMemshow(found, args);
                break;
            }
            case 11: {
                this.procLogset(found, args);
                break;
            }
            case 14: {
                this.procIntset(found, args);
                break;
            }
            case 7: {
                this.procLogshow(found, args);
                break;
            }
            case 15: {
                this.procParmset(found, args);
                break;
            }
            case 8: {
                this.procParmshow(found, args);
                break;
            }
            case 9: {
                this.procVershow(found, args);
                break;
            }
            case 13: {
                this.procReset(found, args);
                break;
            }
            case 16: {
                this.procRestart(found, args);
                break;
            }
            case 17: {
                this.procDatashow(found, args);
                break;
            }
            case 18: {
                this.procPortshow(found, args);
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private void procOpen(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.wtu.open((String)args[0]);
        } else {
            this.wtu.open();
        }
        this.devOpen = true;
        this.fieldMask = this.wtu.getLoggedFields();
    }

    private void procClose(int found, Object[] args) {
        this.wtu.close();
        this.devOpen = false;
    }

    private void procFldset(int found, Object[] args) {
        this.fieldMask = (Integer)args[0];
        int limit = this.wtu.setLoggedFields(this.fieldMask);
        this.out.println((Object)("Record limit = " + limit));
    }

    private void procFldshow(int found, Object[] args) {
        this.out.format("Value = %08x\n", new Object[]{this.wtu.getLoggedFields()});
    }

    private void procCalshow(int found, Object[] args) {
        this.showIntegers(this.wtu.getCalibrationData());
    }

    private void procHdrshow(int found, Object[] args) {
        this.showStrings(this.wtu.getHeaderRecord());
    }

    private void procLimshow(int found, Object[] args) {
        this.out.println((Object)("Record limit = " + this.wtu.getRecordLimit()));
    }

    private void procMemset(int found, Object[] args) {
        this.wtu.setFullOption((Integer)args[0]);
    }

    private void procMemshow(int found, Object[] args) {
        this.out.println((Object)("Memory full option = " + this.wtu.getFullOption()));
    }

    private void procLogset(int found, Object[] args) {
        String type = (String)args[0];
        if (type.equalsIgnoreCase("i")) {
            int intvl = this.wtu.setInternalLogging((Integer)args[1]);
            this.out.println((Object)("Resulting interval = " + intvl));
        } else if (type.equalsIgnoreCase("e")) {
            this.dataSumm = false;
            this.wtu.setExternalLogging((Integer)args[1]);
        } else {
            this.out.println((Object)"Invalid logging type");
        }
    }

    private void procIntset(int found, Object[] args) {
        this.wtu.setLoggingInterval((Integer)args[0]);
    }

    private void procLogshow(int found, Object[] args) {
        this.out.println((Object)("Logging interval = " + this.wtu.getLoggingInterval() + ", logging state = " + this.wtu.getLoggingState()));
    }

    private void procParmset(int found, Object[] args) {
        boolean euro = (found & 4) != 0 && (Integer)args[2] != 0;
        this.wtu.setUserParameters(((Float)args[0]).floatValue(), (Integer)args[1], euro);
    }

    private void procParmshow(int found, Object[] args) {
        this.out.format("Rate = %.3f, threshold = %s, euro = %s\n", new Object[]{Float.valueOf(this.wtu.getUserRate()), this.wtu.getUserThreshold(), this.wtu.getUserEuro()});
    }

    private void procVershow(int found, Object[] args) {
        this.showStrings(this.wtu.getVersionData());
    }

    private void procReset(int found, Object[] args) {
        this.wtu.resetMemory();
    }

    private void procRestart(int found, Object[] args) {
        this.wtu.restart();
    }

    private void procDatashow(int found, Object[] args) {
        this.dataSumm = (found & 1) != 0 && (Integer)args[0] != 0;
        this.dataCount = 0;
        int interval = this.wtu.getLoggedData();
        this.out.println((Object)("Record count = " + this.dataCount + ", logging interval = " + interval));
        this.dataSumm = false;
    }

    private void procPortshow(int found, Object[] args) {
        SerialPort p = this.wtu.getPort();
        if (p == null) {
            this.out.println((Object)"No connection open");
            return;
        }
        this.out.format("CD = %s, CTS = %s, DSR = %s, DTR = %s, RI = %s, RTS = %s\n", new Object[]{p.isCD() ? "on" : "off", p.isCTS() ? "on" : "off", p.isDSR() ? "on" : "off", p.isDTR() ? "on" : "off", p.isRI() ? "on" : "off", p.isRTS() ? "on" : "off"});
    }

    @Override
    public void setPowered(boolean on) {
        this.out.println((Object)("Device powered " + (on ? "on" : "off")));
    }

    @Override
    public void setClosed() {
        this.out.println((Object)"Device connection closed");
        this.devOpen = false;
    }

    @Override
    public void processData(float[] data) {
        ++this.dataCount;
        if (this.dataSumm) {
            if ((this.dataCount & 7) == 0) {
                byte[] flag = new byte[]{flags[this.dataCount >> 3 & 3], 8};
                this.out.write(flag, 0, 2);
            }
        } else {
            this.showFloats(data, this.fieldMask);
        }
    }

    private void showStrings(String[] value) {
        this.out.print((Object)"Values =");
        int posn = 8;
        int j = 0;
        while (j < value.length) {
            String sValue = " " + value[j];
            if ((posn += sValue.length()) > 80) {
                this.out.print((Object)"\n        ");
                posn = 8 + sValue.length();
            }
            this.out.print((Object)sValue);
            ++j;
        }
        this.out.println();
    }

    private void showIntegers(int[] value) {
        this.out.print((Object)"Values =");
        int posn = 8;
        int j = 0;
        while (j < value.length) {
            String sValue = " " + value[j];
            if ((posn += sValue.length()) > 80) {
                this.out.print((Object)"\n        ");
                posn = 8 + sValue.length();
            }
            this.out.print((Object)sValue);
            ++j;
        }
        this.out.println();
    }

    private void showFloats(float[] value, int mask) {
        this.out.print((Object)"Values =");
        int posn = 8;
        int j = 0;
        while (j < value.length) {
            if ((mask & 1 << j) != 0) {
                String sValue = " " + value[j];
                if ((posn += sValue.length()) > 80) {
                    this.out.print((Object)"\n        ");
                    posn = 8 + sValue.length();
                }
                this.out.print((Object)sValue);
            }
            ++j;
        }
        this.out.println();
    }
}

