/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.wattsup;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jline.ConsoleReader;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TalkWatts {
    private final String dfltName = "/dev/ttyUSB0";
    private final Output out = new ConsOut();
    private final ConsoleReader readc = new ConsoleReader();
    private final CommPortIdentifier portId;
    private final SerialPort port;
    private final InputStream winp;
    private final OutputStream wout;
    private final Thread readw = new Thread(new Reader());
    private final Listener listenw = new Listener();
    private boolean gotData = false;
    private byte[] data = new byte[1024];
    private int nRead = 0;
    private int nByte = 0;

    public TalkWatts(String portName) throws Exception {
        if (portName == null) {
            portName = "/dev/ttyUSB0";
        }
        this.portId = CommPortIdentifier.getPortIdentifier((String)portName);
        this.port = (SerialPort)this.portId.open("TalkWatts", 1000);
        this.port.setSerialPortParams(115200, 8, 1, 0);
        this.winp = this.port.getInputStream();
        this.wout = this.port.getOutputStream();
        this.port.addEventListener((SerialPortEventListener)this.listenw);
        this.port.notifyOnDataAvailable(true);
    }

    public static void main(String[] args) throws Exception {
        TalkWatts talk = null;
        try {
            talk = new TalkWatts(args.length > 0 ? args[0] : null);
            talk.run();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (NoSuchPortException e) {
            System.out.println((Object)e);
        }
        catch (PortInUseException e) {
            System.out.println((Object)e);
        }
        catch (UnsupportedCommOperationException e) {
            System.out.println((Object)e);
        }
        System.exit(0);
    }

    public void run() throws IOException {
        String line;
        this.readw.start();
        while ((line = this.readc.readLine("")) != null) {
            if (line.equals("")) {
                this.out.format("#reads: %s; #bytes: %s\n", new Object[]{this.nRead, this.nByte});
            }
            this.wout.write(line.getBytes());
        }
        this.port.close();
    }

    private class Listener
    implements SerialPortEventListener {
        private Listener() {
        }

        public void serialEvent(SerialPortEvent event) {
            if (event.getEventType() == 1) {
                TalkWatts.this.gotData = true;
                TalkWatts.this.readw.interrupt();
            }
        }
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        @Override
        public void run() {
            while (true) {
                int leng;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (!TalkWatts.this.gotData) continue;
                TalkWatts.this.gotData = false;
                try {
                    leng = TalkWatts.this.winp.read(TalkWatts.this.data);
                }
                catch (IOException e) {
                    TalkWatts.this.out.println((Object)e);
                    break;
                }
                if (leng <= 0) break;
                TalkWatts.this.out.write(TalkWatts.this.data, 0, leng);
                TalkWatts talkWatts = TalkWatts.this;
                talkWatts.nRead = talkWatts.nRead + 1;
                TalkWatts talkWatts2 = TalkWatts.this;
                talkWatts2.nByte = talkWatts2.nByte + leng;
            }
        }
    }
}

