package org.lsst.ccs.drivers.usb;

import org.lsst.ccs.drivers.commons.DriverException;

public class ShowDevices {

    public static void main(String[] args) throws DriverException
    {
        long context = UsbLib.init();
        long[] devices = UsbLib.getDeviceList(context);
        System.out.println(devices.length + " devices found");
        for (long device : devices) {
            if (device == 0) continue;
            UsbDeviceDescriptor desc = UsbLib.newDeviceDescriptor(device);
            long handle = 0;
            String mfact = null, product = null, serial = null;
            try {
                handle = UsbLib.open(device);
                try {
                    mfact = UsbLib.getStringDescriptorAscii(handle, desc.iManufacturer());
                }
                catch (DriverException e) {
                }
                try {
                    product = UsbLib.getStringDescriptorAscii(handle, desc.iProduct());
                }
                catch (DriverException e) {
                }
                try {
                    serial = UsbLib.getStringDescriptorAscii(handle, desc.iSerialNumber());
                }
                catch (DriverException e) {
                }
            }
            catch (DriverException e) {
            }
            finally {
                UsbLib.close(handle);
            }
            System.out.format("B=%03d, D=%03d, C=%02x, S=%02x, V=%04x (%s), P=%04x (%s), SN=%s\n",
                              UsbLib.getBusNumber(device), UsbLib.getDeviceAddress(device),
                              desc.bDeviceClass(), desc.bDeviceSubClass(), desc.idVendor(),
                              mfact, desc.idProduct(), product, serial);
            UsbLib.unrefDevice(device);
        }
    }

}
