package org.lsst.ccs.drivers.usb;

/**
 *  The USB interface descriptor.
 *
 *  @author Owen Saxton
 */
public class UsbInterfaceDescriptor extends UsbDescriptor {

    private final byte bInterfaceNumber;
    private final byte bAlternateSetting;
    private final byte bNumEndpoints;
    private final byte bInterfaceClass;
    private final byte bInterfaceSubClass;
    private final byte bInterfaceProtocol;
    private final byte iInterface;


    /**
     *  Constructor.
     *
     *  @param  bLength             Descriptor length
     *  @param  bDescriptorType     Descriptor type
     *  @param  bInterfaceNumber    Interface number
     *  @param  bAlternateSetting   Alternate setting
     *  @param  bNumEndpoints       Number of endpoints
     *  @param  bInterfaceClass     Interface class
     *  @param  bInterfaceSubClass  Interface subclass
     *  @param  bInterfaceProtocol  Interface protocol
     *  @param  iInterface          Interface string index
     */
    public UsbInterfaceDescriptor(byte bLength, byte bDescriptorType,
                                  byte bInterfaceNumber,
                                  byte bAlternateSetting, byte bNumEndpoints,
                                  byte bInterfaceClass,
                                  byte bInterfaceSubClass,
                                  byte bInterfaceProtocol, byte iInterface )
    {
        super(bLength, bDescriptorType);
        this.bInterfaceNumber = bInterfaceNumber;
        this.bAlternateSetting = bAlternateSetting;
        this.bNumEndpoints = bNumEndpoints;
        this.bInterfaceClass = bInterfaceClass;
        this.bInterfaceSubClass = bInterfaceSubClass;
        this.bInterfaceProtocol = bInterfaceProtocol;
        this.iInterface = iInterface;
    }


    /**
     *  Gets the interface number.
     *
     *  @return  The interface number
     */
    public int bInterfaceNumber()
    {
        return bInterfaceNumber & 0xff;
    }


    /**
     *  Gets the alternate setting.
     *
     *  @return  The alternate setting
     */
    public int bAlternateSetting()
    {
        return bAlternateSetting & 0xff;
    }


    /**
     *  Gets the number of endpoints.
     *
     *  @return  The number of endpoints
     */
    public int bNumEndpoints()
    {
        return bNumEndpoints & 0xff;
    }


    /**
     *  Gets the interface class.
     *
     *  @return  The interface class
     */
    public int bInterfaceClass()
    {
        return bInterfaceClass & 0xff;
    }


    /**
     *  Gets the interface subclass.
     *
     *  @return  The interface subclass
     */
    public int bInterfaceSubClass()
    {
        return bInterfaceSubClass & 0xff;
    }


    /**
     *  Gets the interface protocol.
     *
     *  @return  The interface protocol
     */
    public int bInterfaceProtocol()
    {
        return bInterfaceProtocol & 0xff;
    }


    /**
     *  Gets the interface string descriptor index.
     *
     *  @return  The interface string descriptor index
     */
    public int iInterface()
    {
        return iInterface & 0xff;
    }

}
