package org.lsst.ccs.drivers.usb;

/**
 *  The USB endpoint descriptor.
 *
 *  @author Owen Saxton
 */
public class UsbEndpointDescriptor extends UsbDescriptor {

    private final byte bEndpointAddress;
    private final byte bmAttributes;
    private final short wMaxPacketSize;
    private final byte bInterval;


    /**
     *  Constructor.
     *
     *  @param  bLength           Descriptor length
     *  @param  bDescriptorType   Descriptor type
     *  @param  bEndpointAddress  Endpoint address
     *  @param  bmAttributes      Mask of attributes
     *  @param  bInterval         Polling interval
     *  @param  wMaxPacketSize    Maximum packet size
     */
    public UsbEndpointDescriptor(byte bLength, byte bDescriptorType,
                                 byte bEndpointAddress, byte bmAttributes,
                                 byte bInterval, short wMaxPacketSize)
    {
        super(bLength, bDescriptorType);
        this.bEndpointAddress = bEndpointAddress;
        this.bmAttributes = bmAttributes;
        this.bInterval = bInterval;
        this.wMaxPacketSize = wMaxPacketSize;
    }


    /**
     *  Gets the endpoint address.
     *
     *  @return  The endpoint address
     */
    public int bEndpointAddress()
    {
        return bEndpointAddress & 0xff;
    }


    /**
     *  Gets the attributes.
     *
     *  @return  The attributes
     */
    public int bmAttributes()
    {
        return bmAttributes & 0xff;
    }


    /**
     *  Gets the maximum packet size.
     *
     *  @return  The maximum packet size
     */
    public int wMaxPacketSize()
    {
        return wMaxPacketSize & 0xffff;
    }


    /**
     *  Gets the polling interval.
     *
     *  @return  The polling interval
     */
    public int bInterval()
    {
        return bInterval & 0xff;
    }

}
