package org.lsst.ccs.drivers.usb;

/**
 *  The USB configuration descriptor.
 *
 *  @author Owen Saxton
 */
public class UsbConfigurationDescriptor extends UsbDescriptor {

    private final short wTotalLength;
    private final byte bNumInterfaces;
    private final byte bConfigurationValue;
    private final byte iConfiguration;
    private final byte bmAttributes;
    private final byte bMaxPower;


    /**
     *  Constructor.
     *
     *  @param  bLength              Descriptor length
     *  @param  bDescriptorType      Descriptor type
     *  @param  wTotalLength         Total length
     *  @param  bNumInterfaces       Number of interfaces
     *  @param  bConfigurationValue  Configuration value
     *  @param  iConfiguration       Configuration string index
     *  @param  bmAttributes         Attributes
     *  @param  bMaxPower            Maximum power
     */
    public UsbConfigurationDescriptor(byte bLength, byte bDescriptorType,
                                      short wTotalLength,
                                      byte bNumInterfaces,
                                      byte bConfigurationValue,
                                      byte iConfiguration, byte bmAttributes,
                                      byte bMaxPower)
    {
        super(bLength, bDescriptorType);
        this.wTotalLength = wTotalLength;
        this.bNumInterfaces = bNumInterfaces;
        this.bConfigurationValue = bConfigurationValue;
        this.iConfiguration = iConfiguration;
        this.bmAttributes = bmAttributes;
        this.bMaxPower = bMaxPower;
    }


    /**
     *  Gets the total length.
     *
     *  @return  The total length
     */
    public int wTotalLength()
    {
        return wTotalLength & 0xffff;
    }


    /**
     *  Gets the number of interfaces.
     *
     *  @return  The number of interfaces
     */
    public int bNumInterfaces()
    {
        return bNumInterfaces & 0xff;
    }


    /**
     *  Gets the configuration value.
     *
     *  @return  The configuration value
     */
    public int bConfigurationValue()
    {
        return bConfigurationValue & 0xff;
    }


    /**
     *  Gets the configuration index.
     *
     *  @return  The configuration index
     */
    public int iConfiguration()
    {
        return iConfiguration & 0xff;
    }


    /**
     *  Gets the attributes.
     *
     *  @return  The attributes
     */
    public int bmAttributes()
    {
        return bmAttributes & 0xff;
    }


    /**
     *  Gets the maximum power.
     *
     *  @return  The maximum power
     */
    public int bMaxPower()
    {
        return bMaxPower & 0xff;
    }

}
