package org.lsst.ccs.drivers.usb;

import java.io.PrintStream;
import java.util.List;
import org.lsst.ccs.drivers.commons.DriverException;

public class ShowAll {

    private final static PrintStream out = System.out;

    public static void main(String[] args) throws DriverException
    {
        List<UsbDevice> devs = UsbLib.getDevices(-1, -1, null);
        out.println(devs.size() + " devices found");
        for (UsbDevice dev : devs) {
            UsbDeviceDescriptor desc = dev.getDescriptor();
            out.format("\nDevice: Bus=%03d  Addr=%03d  Vid=%04x  Pid=%04x  Ncfg=%s\n",
                       dev.getBusNumber(), dev.getAddress(), desc.idVendor(),
                       desc.idProduct(), desc.bNumConfigurations());
            List<UsbConfiguration> cfgs = dev.getConfigurations();
            for (UsbConfiguration cfg : cfgs) {
                UsbConfigurationDescriptor cDesc = cfg.getDescriptor();
                List<UsbInterface> ifcs = cfg.getInterfaces();
                out.format("  Configuration: ID=%s  Nif=%s\n",
                           cDesc.bConfigurationValue(), ifcs.size());
                for (UsbInterface ifc : ifcs) {
                    List<UsbInterface> alts = ifc.getSettings();
                    out.format("    Interface: Nalt=%s\n", alts.size());
                    for (UsbInterface alt : alts) {
                        UsbInterfaceDescriptor aDesc = alt.getDescriptor();
                        out.format("      AltSetting: Inum=%s  Anum=%s  Nep=%s\n",
                                   aDesc.bInterfaceNumber(),
                                   aDesc.bAlternateSetting(),
                                   aDesc.bNumEndpoints());
                        List<UsbEndpoint> eps = alt.getEndpoints();
                        for (UsbEndpoint ep : eps) {
                            UsbEndpointDescriptor eDesc = ep.getDescriptor();
                            out.format("        Endpoint: Addr=%02x\n",
                                       eDesc.bEndpointAddress());
                        }
                    }
                }
            }
        }
    }

}
