package org.lsst.ccs.drivers.usb;

/**
 ******************************************************************************
 **
 **  Operations for a USB endpoint
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class UsbEndpoint {
    
    private final UsbEndpointDescriptor desc;
    private final UsbDevice devc;


   /**
    ***************************************************************************
    **
    **  Constructor.
    **
    ***************************************************************************
    */
    UsbEndpoint(UsbEndpointDescriptor desc, UsbDevice devc)
    {
        this.desc = desc;
        this.devc = devc;
    }


   /**
    ***************************************************************************
    **
    **  Gets the endpoint descriptor.
    **
    **  @return  The endpoint descriptor
    **
    ***************************************************************************
    */
    public UsbEndpointDescriptor getDescriptor()
    {
        return desc;
    }

}
