/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.usb.UsbConfiguration;
import org.lsst.ccs.drivers.usb.UsbConfigurationDescriptor;
import org.lsst.ccs.drivers.usb.UsbDevice;
import org.lsst.ccs.drivers.usb.UsbDeviceDescriptor;
import org.lsst.ccs.drivers.usb.UsbEndpoint;
import org.lsst.ccs.drivers.usb.UsbEndpointDescriptor;
import org.lsst.ccs.drivers.usb.UsbInterface;
import org.lsst.ccs.drivers.usb.UsbInterfaceDescriptor;
import org.lsst.ccs.drivers.usb.UsbLib;

public class TestUsbLib {
    private static final Map<Integer, String> speedMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> devcMap;
    private static final Map<Integer, String> cfgaMap;
    private static final Map<Integer, String> epaMap;
    private static final PrintStream out;
    private UsbDevice devc;

    static {
        speedMap.put(0, "Unknown");
        speedMap.put(1, "Low");
        speedMap.put(2, "Full");
        speedMap.put(3, "High");
        speedMap.put(4, "Super");
        devcMap = new HashMap<Integer, String>();
        devcMap.put(0, "See interface");
        devcMap.put(1, "Audio");
        devcMap.put(2, "Communications");
        devcMap.put(3, "Human intface");
        devcMap.put(5, "Physical");
        devcMap.put(6, "Still image");
        devcMap.put(7, "Printer");
        devcMap.put(9, "Hub");
        devcMap.put(8, "Mass storage");
        devcMap.put(10, "Data");
        devcMap.put(11, "Smart card");
        devcMap.put(13, "Content secty");
        devcMap.put(14, "Video");
        devcMap.put(15, "Healthcare");
        devcMap.put(220, "Diagnostic");
        devcMap.put(224, "Wireless");
        devcMap.put(239, "Miscellaneous");
        devcMap.put(254, "App specific");
        devcMap.put(255, "Vendor spec");
        cfgaMap = new HashMap<Integer, String>();
        cfgaMap.put(64, "Self-powered");
        cfgaMap.put(32, "Remote wakeup");
        epaMap = new HashMap<Integer, String>();
        epaMap.put(0, "Control");
        epaMap.put(1, "Isochronous");
        epaMap.put(2, "Bulk");
        epaMap.put(3, "Interrupt");
        out = System.out;
    }

    @Command(name="connect", description="Connect to a USB device")
    public void connect(@Argument(name="vendId", description="The vendor ID, or -1 for all") int vendId, @Argument(name="devId", description="The device ID, or -1 for all") int devId, @Argument(name="serial", description="The serial number, or empty for all") String serial, @Argument(name="index", description="Index in list of matching devices") int index) throws DriverException {
        if (this.devc != null) {
            out.println("Device already connected");
        } else {
            this.devc = UsbLib.getDevice(vendId, devId, serial, index);
            if (this.devc == null) {
                out.println("Device not found");
            }
        }
    }

    @Command(name="connect", description="Connect to a USB device")
    public void connect(@Argument(name="index", description="Index in list of all devices") int index) throws DriverException {
        this.connect(-1, -1, null, index);
    }

    @Command(name="disconnect", description="Disconnect from a USB device")
    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.devc.close();
        this.devc = null;
    }

    @Command(name="readcontrol", description="Read from the control endpoint")
    public void readControl(@Argument(name="type", description="Request type") int type, @Argument(name="request", description="Request code") int request, @Argument(name="value", description="Value") int value, @Argument(name="index", description="Index") int index, @Argument(name="leng", description="No. bytes to read") int leng, @Argument(name="timeout", description="Timeout (ms)") int timeout) throws DriverException {
        if (!this.isConnected()) {
            return;
        }
        byte[] data = new byte[leng];
        int nRead = this.devc.controlRead(type, request, value, index, data, 0, leng, timeout);
        this.dispData(data, nRead);
    }

    @Command(name="writecontrol", description="Write to the control endpoint")
    public void writeControl(@Argument(name="type", description="Request type") int type, @Argument(name="request", description="Request code") int request, @Argument(name="value", description="Value") int value, @Argument(name="index", description="Index") int index, @Argument(name="timeout", description="Timeout (ms)") int timeout, @Argument(name="data0", description="First byte of data to write") int data0, int ... data) throws DriverException {
        if (!this.isConnected()) {
            return;
        }
        byte[] wData = new byte[data.length + 1];
        wData[0] = (byte)data0;
        int j = 0;
        while (j < data.length) {
            wData[j + 1] = (byte)data[j];
            ++j;
        }
        int nWrite = this.devc.controlWrite(type, request, value, index, wData, 0, wData.length, timeout);
        out.println(String.valueOf(nWrite) + " bytes written");
    }

    @Command(name="readbulk", description="Read bulk data")
    public void readBulk(@Argument(name="endpoint", description="Endpoint address") int endp, @Argument(name="leng", description="No. bytes to read") int leng, @Argument(name="timeout", description="Timeout (ms)") int timeout) throws DriverException {
        if (!this.isConnected()) {
            return;
        }
        byte[] data = new byte[leng];
        int nRead = this.devc.bulkRead(endp, data, 0, leng, timeout);
        this.dispData(data, nRead);
    }

    @Command(name="writebulk", description="Write bulk data")
    public void writeBulk(@Argument(name="endpoint", description="Endpoint address") int endp, @Argument(name="timeout", description="Timeout (ms)") int timeout, @Argument(name="data0", description="First byte of data to write") int data0, int ... data) throws DriverException {
        if (!this.isConnected()) {
            return;
        }
        byte[] wData = new byte[data.length + 1];
        wData[0] = (byte)data0;
        int j = 0;
        while (j < data.length) {
            wData[j + 1] = (byte)data[j];
            ++j;
        }
        int nWrite = this.devc.bulkWrite(endp, wData, 0, wData.length, timeout);
        out.println(String.valueOf(nWrite) + " bytes written");
    }

    @Command(name="claim", description="Claim an interface")
    public void claim(@Argument(name="ifcnum", description="Interface number") int ifcnum, @Argument(name="force", description="Force the claim") boolean force) throws DriverException {
        if (!this.isConnected()) {
            return;
        }
        this.devc.claimInterface(ifcnum, force);
    }

    @Command(name="release", description="Release an interface")
    public void release(@Argument(name="ifcnum", description="Interface number") int ifcnum) throws DriverException {
        if (!this.isConnected()) {
            return;
        }
        this.devc.releaseInterface(ifcnum);
    }

    @Command(name="setconfig", description="Sets the active configuration")
    public void setConfig(@Argument(name="cfgnum", description="Configuration number") int cfgnum) throws DriverException {
        if (!this.isConnected()) {
            return;
        }
        this.devc.setActiveConfiguration(cfgnum);
    }

    @Command(name="setinterface", description="Sets the interface")
    public void setInterface(@Argument(name="ifcnum", description="Interface number") int ifcnum, @Argument(name="altnum", description="Alternate setting number") int altnum) throws DriverException {
        if (!this.isConnected()) {
            return;
        }
        this.devc.setAltSetting(ifcnum, altnum);
    }

    @Command(name="showbus", description="Show all the devices on the bus")
    public void showBus() throws DriverException {
        List<UsbDevice> devs = UsbLib.getDevices(-1, -1, null);
        if (!devs.isEmpty()) {
            int j = 0;
            while (j < devs.size()) {
                UsbDevice dev = devs.get(j);
                if (j > 0) {
                    out.println();
                }
                out.println("Device " + j + ":");
                this.dispDevice(dev);
                ++j;
            }
        } else {
            out.println("No devices found");
        }
    }

    @Command(name="showdevice", description="Show a device")
    public void showDevice(@Argument(name="devnum", description="Device number") int devnum) throws DriverException {
        UsbDevice dev = this.getDevice(devnum);
        if (dev != null) {
            this.dispDevice(dev);
        }
    }

    @Command(name="showdevice", description="Show the connected device")
    public void showDevice() throws DriverException {
        this.showDevice(-1);
    }

    @Command(name="showconfig", description="Show a configuration")
    public void showConfig(@Argument(name="cfgnum", description="Configuration number") int cfgnum, @Argument(name="devnum", description="Device number") int devnum) throws DriverException {
        UsbDevice dev = this.getDevice(devnum);
        if (dev == null) {
            return;
        }
        UsbConfiguration cfg = this.getConfiguration(dev, cfgnum);
        if (cfg == null) {
            return;
        }
        this.dispConfiguration(cfg);
    }

    @Command(name="showconfig", description="Show a configuration")
    public void showConfig(@Argument(name="cfgnum", description="Configuration number") int cfgnum) throws DriverException {
        this.showConfig(cfgnum, -1);
    }

    @Command(name="showconfig", description="Show the active configuration")
    public void showConfig() throws DriverException {
        this.showConfig(-1, -1);
    }

    @Command(name="showinterface", description="Show an interface")
    public void showIntfce(@Argument(name="ifcnum", description="Interface number") int ifcnum, @Argument(name="altnum", description="Alternate setting number") int altnum, @Argument(name="cfgnum", description="Configuration number") int cfgnum, @Argument(name="devnum", description="Device number") int devnum) throws DriverException {
        UsbDevice dev = this.getDevice(devnum);
        if (dev == null) {
            return;
        }
        UsbConfiguration cfg = this.getConfiguration(dev, cfgnum);
        if (cfg == null) {
            return;
        }
        UsbInterface ifc = this.getInterface(cfg, ifcnum, altnum);
        if (ifc == null) {
            return;
        }
        this.dispInterface(ifc);
    }

    @Command(name="showinterface", description="Show an interface")
    public void showIntfce(@Argument(name="ifcnum", description="Interface number") int ifcnum, @Argument(name="altnum", description="Alternate setting number") int altnum, @Argument(name="cfgnum", description="Configuration number") int cfgnum) throws DriverException {
        this.showIntfce(ifcnum, altnum, cfgnum, -1);
    }

    @Command(name="showinterface", description="Show an interface")
    public void showIntfce(@Argument(name="ifcnum", description="Interface number") int ifcnum, @Argument(name="altnum", description="Alternate setting number") int altnum) throws DriverException {
        this.showIntfce(ifcnum, altnum, -1, -1);
    }

    @Command(name="showinterface", description="Show an interface")
    public void showIntfce(@Argument(name="ifcnum", description="Interface number") int ifcnum) throws DriverException {
        this.showIntfce(ifcnum, -1, -1, -1);
    }

    @Command(name="showendpoint", description="Show an endpoint")
    public void showEndpt(@Argument(name="endp", description="Endpoint address") int endp, @Argument(name="ifcnum", description="Interface number") int ifcnum, @Argument(name="altnum", description="Alternate setting number") int altnum, @Argument(name="cfgnum", description="Configuration number") int cfgnum, @Argument(name="devnum", description="Device number") int devnum) throws DriverException {
        UsbDevice dev = this.getDevice(devnum);
        if (dev == null) {
            return;
        }
        UsbConfiguration cfg = this.getConfiguration(dev, cfgnum);
        if (cfg == null) {
            return;
        }
        UsbInterface ifc = this.getInterface(cfg, ifcnum, altnum);
        if (ifc == null) {
            return;
        }
        UsbEndpoint ep = ifc.getEndpoint(endp);
        if (ep == null) {
            out.println("Endpoint not found");
            return;
        }
        this.dispEndpoint(ep);
    }

    @Command(name="showendpoint", description="Show an endpoint")
    public void showEndpt(@Argument(name="endp", description="Endpoint address") int endp, @Argument(name="ifcnum", description="Interface number") int ifcnum, @Argument(name="altnum", description="Alternate setting number") int altnum, @Argument(name="cfgnum", description="Configuration number") int cfgnum) throws DriverException {
        this.showEndpt(endp, ifcnum, altnum, cfgnum, -1);
    }

    @Command(name="showendpoint", description="Show an endpoint")
    public void showEndpt(@Argument(name="endp", description="Endpoint address") int endp, @Argument(name="ifcnum", description="Interface number") int ifcnum, @Argument(name="altnum", description="Alternate setting number") int altnum) throws DriverException {
        this.showEndpt(endp, ifcnum, altnum, -1, -1);
    }

    @Command(name="showendpoint", description="Show an endpoint")
    public void showEndpt(@Argument(name="endp", description="Endpoint address") int endp, @Argument(name="ifcnum", description="Interface number") int ifcnum) throws DriverException {
        this.showEndpt(endp, ifcnum, -1, -1, -1);
    }

    private UsbDevice getDevice(int index) throws DriverException {
        if (index < 0) {
            this.isConnected();
            return this.devc;
        }
        List<UsbDevice> devs = UsbLib.getDevices(-1, -1, null);
        if (index < devs.size()) {
            return devs.get(index);
        }
        out.println("Device not found");
        return null;
    }

    private UsbConfiguration getConfiguration(UsbDevice devc, int cfgnum) throws DriverException {
        UsbConfiguration cfg;
        if (cfgnum < 0) {
            cfg = devc.getActiveConfiguration();
            if (cfg == null) {
                out.println("No configuration active");
            }
        } else {
            cfg = devc.getConfigurationByValue(cfgnum);
            if (cfg == null) {
                out.println("Configuration not found");
            }
        }
        return cfg;
    }

    private UsbInterface getInterface(UsbConfiguration cfg, int ifcnum, int altnum) throws DriverException {
        UsbInterface ifc = cfg.getInterface(ifcnum);
        if (ifc != null) {
            ifc = altnum < 0 ? ifc.getActiveSetting() : ifc.getSetting(altnum);
        }
        if (ifc == null) {
            out.println("Interface not found");
        }
        return ifc;
    }

    private void dispData(byte[] data, int count) {
        String cnt = String.valueOf(count) + " bytes read";
        String pad = String.format("%24s", "").substring(0, cnt.length() + 1);
        out.print(cnt);
        int j = 0;
        while (j < count) {
            if ((j & 0xF) == 0) {
                if (j == 0) {
                    out.print(":");
                } else {
                    out.println();
                    out.print(pad);
                }
            }
            out.format(" %02x", data[j] & 0xFF);
            ++j;
        }
        out.println();
    }

    private byte[] genData(int found, Object[] args) {
        int count = 0;
        int mask = found;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int j = 0;
        while (found != 0) {
            if ((found & 1) != 0) {
                String hex = (String)args[j];
                int leng = hex.length();
                if ((leng & 1) != 0) break;
                byte[] sData = new byte[leng / 2];
                try {
                    int k = 0;
                    while (k < leng) {
                        String num = hex.substring(k, k + 2);
                        sData[k / 2] = (byte)Integer.parseInt(num, 16);
                        k += 2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
                count += leng / 2;
                list.add(sData);
                mask ^= 1 << j;
            }
            found >>= 1;
            ++j;
        }
        if (mask != 0) {
            out.println("Invalid hexadecimal string");
            return null;
        }
        byte[] data = new byte[count];
        int l = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            byte[] sData;
            byte[] byArray = sData = (byte[])iterator.next();
            int n = sData.length;
            int n2 = 0;
            while (n2 < n) {
                byte datum = byArray[n2];
                data[l++] = datum;
                ++n2;
            }
        }
        return data;
    }

    private void dispDevice(UsbDevice dev) throws DriverException {
        UsbDeviceDescriptor desc = dev.getDescriptor();
        out.format("Vendor ID (name)    : 0x%04x (%s)\n", desc.idVendor(), dev.getManufacturer());
        out.format("Product ID (name)   : 0x%04x (%s)\n", desc.idProduct(), dev.getProduct());
        out.println("Serial number       : " + dev.getSerialNumber());
        out.println("Device speed        : " + speedMap.get(dev.getSpeed()));
        int cls = desc.bDeviceClass();
        out.format("Device class        : %s (%s)\n", cls, devcMap.get(cls));
        out.println("Device subclass     : " + desc.bDeviceSubClass());
        out.println("Device protocol     : " + desc.bDeviceProtocol());
        out.format("USB release         : %04x\n", desc.bcdUSB());
        out.println("Number of configs   : " + desc.bNumConfigurations());
        UsbConfiguration cfg = dev.getActiveConfiguration();
        out.println("Active config number: " + cfg.getDescriptor().bConfigurationValue());
        out.println("Maximum packet size : " + desc.bMaxPacketSize0());
    }

    private void dispConfiguration(UsbConfiguration cfg) {
        UsbConfigurationDescriptor desc = cfg.getDescriptor();
        out.format("ConfigNum (name) : %s (%s)\n", desc.bConfigurationValue(), cfg.getString());
        int attr = desc.bmAttributes();
        StringBuilder sAttr = new StringBuilder();
        int j = 0;
        int mask = 1;
        while (j < 8) {
            if ((attr & mask) != 0) {
                String name;
                if (sAttr.length() != 0) {
                    sAttr.append(", ");
                }
                sAttr.append((name = cfgaMap.get(mask)) != null ? name : "??");
            }
            ++j;
            mask <<= 1;
        }
        out.format("Attributes       : 0x%02x (%s)\n", attr, sAttr);
        out.format("Maximum power    : %s mA\n", 2 * desc.bMaxPower());
        out.println("Number interfaces: " + desc.bNumInterfaces());
    }

    private void dispInterface(UsbInterface ifc) {
        UsbInterfaceDescriptor desc = ifc.getDescriptor();
        out.format("Interface no. (name): %s (%s)\n", desc.bInterfaceNumber(), ifc.getString());
        out.println("Setting number      : " + desc.bAlternateSetting());
        out.println("Active setting no.  : " + ifc.getActiveSettingNumber());
        out.println("Number of settings  : " + ifc.getNumSettings());
        int cls = desc.bInterfaceClass();
        out.format("Interface class     : %s (%s)\n", cls, devcMap.get(cls));
        out.println("Interface subclass  : " + desc.bInterfaceSubClass());
        out.println("Interface protocol  : " + desc.bInterfaceProtocol());
        out.println("Number of endpoints : " + desc.bNumEndpoints());
        out.print("Endpoint addressess :");
        List<UsbEndpoint> eps = ifc.getEndpoints();
        for (UsbEndpoint ep : eps) {
            UsbEndpointDescriptor epDesc = ep.getDescriptor();
            out.format(" 0x%02x", epDesc.bEndpointAddress());
        }
        out.println();
    }

    private void dispEndpoint(UsbEndpoint ep) {
        UsbEndpointDescriptor desc = ep.getDescriptor();
        out.format("Address          : 0x%02x\n", desc.bEndpointAddress());
        int attr = desc.bmAttributes();
        out.format("Attributes       : 0x%02x (%s)\n", attr, epaMap.get(attr & 3));
        out.format("Interval         : %s msec\n", desc.bInterval());
        out.println("Maxm packet size : " + desc.wMaxPacketSize());
    }

    private boolean isConnected() {
        if (this.devc == null) {
            out.println("No device connected");
            return false;
        }
        return true;
    }
}

