package org.lsst.ccs.drivers.usb;

/**
 ******************************************************************************
 **
 **  Common part of a USB descriptor
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class UsbDescriptor {

    private final byte bLength;
    private final byte bDescriptorType;


   /**
    ***************************************************************************
    **
    **  Constructor.
    **
    **  @param  bLength          Descriptor length
    **
    **  @param  bDescriptorType  Descriptor type
    **
    ***************************************************************************
    */
    public UsbDescriptor(byte bLength, byte bDescriptorType)
    {
        this.bLength = bLength;
        this.bDescriptorType = bDescriptorType;
    }
    

   /**
    ***************************************************************************
    **
    **  Gets the length.
    **
    **  @return  The length
    **
    ***************************************************************************
    */
    public int bLength()
    {
        return bLength & 0xff;
    }


   /**
    ***************************************************************************
    **
    **  Gets the descriptor type.
    **
    **  @return  The descriptor type
    **
    ***************************************************************************
    */
    public int bDescriptorType()
    {
        return bDescriptorType & 0xff;
    }

}
