package org.lsst.ccs.drivers.usb;

import java.util.List;
import org.lsst.ccs.drivers.commons.DriverException;

public class ShowDevs {

    public static void main(String[] args) throws DriverException
    {
        List<UsbDevice> devs = UsbLib.getDevices(-1, -1, null);
        System.out.println(devs.size() + " devices found");
        for (UsbDevice dev : devs) {
            UsbDeviceDescriptor desc = dev.getDescriptor();
            String mfact, product, serial;
            mfact = dev.getManufacturer();
            product = dev.getProduct();
            serial = dev.getSerialNumber();
            System.out.format("C=%02x, S=%02x, V=%04x (%s), P=%04x (%s), SN=%s\n",
                              desc.bDeviceClass(), desc.bDeviceSubClass(),
                              desc.idVendor(), mfact, desc.idProduct(), product,
                              serial);
        }
    }

}
