#! /bin/sh

#
#  Runs the specified USB test program
#
#  Usage:  runUsb.sh <class> [<arguments>]
#
#    class  The class containing the main program to run
#
#  The available classes are:
#
#    com.ibm.jusb.tools.UsbView
#    com.ibm.jusb.tools.swing.SwingUsbView
#    com.ibm.jusb.tools.text.TextUsbView
#    javax.usb.examples.DefaultControlPipe
#    javax.usb.examples.FindUsbDevice
#    javax.usb.examples.FindUsbInterface
#    javax.usb.examples.MouseDriver
#    javax.usb.examples.ShowTopology
#    org.lsst.ccs.drivers.usb.TestUsbComm (run by testUsb.sh)
#

name=`readlink -fn $0`
cd `dirname $name`
JAR=`ls -r ../share/java/org-lsst-ccs-drivers-usb-*.jar`
CP=${JAR//$'\n'/:}
LDP=../lib/jni:../lib
LD_LIBRARY_PATH=$LDP java -cp $CP $1 $2 $3 $4 $5
