/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.usb.UsbConfiguration;
import org.lsst.ccs.drivers.usb.UsbDeviceDescriptor;
import org.lsst.ccs.drivers.usb.UsbLib;

public class UsbDevice {
    private final long devc;
    private long devh;
    private final UsbDeviceDescriptor desc;
    private Map<Integer, Integer> altMap = new HashMap<Integer, Integer>();

    UsbDevice(long devc, long devh, UsbDeviceDescriptor desc) throws DriverException {
        this.devc = devc;
        this.devh = devh;
        this.desc = desc;
    }

    public UsbDeviceDescriptor getDescriptor() {
        return this.desc;
    }

    public int getBusNumber() {
        return UsbLib.getBusNumber(this.devc);
    }

    public int getPortNumber() {
        return UsbLib.getPortNumber(this.devc);
    }

    public int getAddress() {
        return UsbLib.getDeviceAddress(this.devc);
    }

    public int getSpeed() {
        return UsbLib.getDeviceSpeed(this.devc);
    }

    public List<UsbConfiguration> getConfigurations() throws DriverException {
        ArrayList<UsbConfiguration> cfgs = new ArrayList<UsbConfiguration>();
        int j = 0;
        while (j < this.desc.bNumConfigurations()) {
            long cfgd = UsbLib.getConfigDescriptor(this.devc, j);
            cfgs.add(UsbLib.buildConfiguration(cfgd, this));
            UsbLib.freeConfigDescriptor(cfgd);
            ++j;
        }
        return cfgs;
    }

    public UsbConfiguration getActiveConfiguration() throws DriverException {
        long cfgd = UsbLib.getActiveConfigDescriptor(this.devc);
        if (cfgd == 0L) {
            return null;
        }
        UsbConfiguration cfg = UsbLib.buildConfiguration(cfgd, this);
        UsbLib.freeConfigDescriptor(cfgd);
        return cfg;
    }

    public UsbConfiguration getConfiguration(int index) throws DriverException {
        long cfgd = UsbLib.getConfigDescriptor(this.devc, index);
        if (cfgd == 0L) {
            return null;
        }
        UsbConfiguration cfg = UsbLib.buildConfiguration(cfgd, this);
        UsbLib.freeConfigDescriptor(cfgd);
        return cfg;
    }

    public UsbConfiguration getConfigurationByValue(int value) throws DriverException {
        long cfgd = UsbLib.getConfigDescriptorByValue(this.devc, value);
        if (cfgd == 0L) {
            return null;
        }
        UsbConfiguration cfg = UsbLib.buildConfiguration(cfgd, this);
        UsbLib.freeConfigDescriptor(cfgd);
        return cfg;
    }

    public void close() {
        UsbLib.closeDev(this.devh);
    }

    public int getActiveConfigurationNumber() throws DriverException {
        return UsbLib.getConfiguration(this.getLibusbHandle());
    }

    public void setActiveConfiguration(int cfgnum) throws DriverException {
        UsbLib.setConfiguration(this.getLibusbHandle(), cfgnum);
    }

    public void claimInterface(int ifcnum, boolean force) throws DriverException {
        if (force) {
            this.detachDriver(ifcnum);
        }
        UsbLib.claimInterface(this.getLibusbHandle(), ifcnum);
    }

    public void releaseInterface(int ifcnum) throws DriverException {
        UsbLib.releaseInterface(this.getLibusbHandle(), ifcnum);
    }

    public void detachDriver(int ifcnum) throws DriverException {
        UsbLib.detachKernelDriver(this.getLibusbHandle(), ifcnum);
    }

    public void attachDriver(int ifcnum) throws DriverException {
        UsbLib.attachKernelDriver(this.getLibusbHandle(), ifcnum);
    }

    public void setAutoDetachDriver(boolean enable) throws DriverException {
        UsbLib.setAutoDetachKernelDriver(this.getLibusbHandle(), enable);
    }

    public void setAltSetting(int ifcnum, int altnum) throws DriverException {
        UsbLib.setInterfaceAltSetting(this.getLibusbHandle(), ifcnum, altnum);
        this.altMap.put(ifcnum, altnum);
    }

    public int getAltSetting(int ifcnum) {
        Integer altnum = this.altMap.get(ifcnum);
        return altnum == null ? 0 : altnum;
    }

    public String getString(int index) {
        try {
            return UsbLib.getStringDescriptorAscii(this.getLibusbHandle(), index);
        }
        catch (DriverException driverException) {
            return null;
        }
    }

    public String getManufacturer() {
        return this.getString(this.desc.iManufacturer());
    }

    public String getProduct() {
        return this.getString(this.desc.iProduct());
    }

    public String getSerialNumber() {
        return this.getString(this.desc.iSerialNumber());
    }

    public void reset() throws DriverException {
        UsbLib.resetDevice(this.getLibusbHandle());
    }

    public int controlRead(int type, int rqst, int value, int index, byte[] data, int offset, int leng, int timeout) throws DriverException {
        if ((type & 0x80) == 0) {
            throw new DriverException("usb error: read request on write e/p");
        }
        return UsbLib.controlTransfer(this.getLibusbHandle(), type, rqst, value, index, data, offset, leng, timeout);
    }

    public int controlWrite(int type, int rqst, int value, int index, byte[] data, int offset, int leng, int timeout) throws DriverException {
        if ((type & 0x80) != 0) {
            throw new DriverException("usb error: write request on read e/p");
        }
        return UsbLib.controlTransfer(this.getLibusbHandle(), type, rqst, value, index, data, offset, leng, timeout);
    }

    public int bulkRead(int endp, byte[] data, int offset, int leng, int timeout) throws DriverException {
        if ((endp & 0x80) == 0) {
            throw new DriverException("usb error: read request on write e/p");
        }
        return UsbLib.bulkTransfer(this.getLibusbHandle(), endp, data, offset, leng, timeout);
    }

    public int bulkWrite(int endp, byte[] data, int offset, int leng, int timeout) throws DriverException {
        if ((endp & 0x80) != 0) {
            throw new DriverException("usb error: write request on read e/p");
        }
        return UsbLib.bulkTransfer(this.getLibusbHandle(), endp, data, offset, leng, timeout);
    }

    public int interruptRead(int endp, byte[] data, int offset, int leng, int timeout) throws DriverException {
        if ((endp & 0x80) == 0) {
            throw new DriverException("usb error: read request on write e/p");
        }
        return UsbLib.interruptTransfer(this.getLibusbHandle(), endp, data, offset, leng, timeout);
    }

    public int interruptWrite(int endp, byte[] data, int offset, int leng, int timeout) throws DriverException {
        if ((endp & 0x80) != 0) {
            throw new DriverException("usb error: write request on read e/p");
        }
        return UsbLib.interruptTransfer(this.getLibusbHandle(), endp, data, offset, leng, timeout);
    }

    long getLibusbDevice() {
        return this.devc;
    }

    long getLibusbHandle() throws DriverException {
        if (this.devh == 0L) {
            this.devh = UsbLib.openDev(this.devc);
        }
        return this.devh;
    }
}

