/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConst;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;
import javax.usb.event.UsbDeviceDataEvent;
import javax.usb.event.UsbDeviceErrorEvent;
import javax.usb.event.UsbDeviceEvent;
import javax.usb.event.UsbDeviceListener;
import javax.usb.util.StandardRequest;
import org.lsst.ccs.drivers.usb.UsbCommPipe;
import org.lsst.ccs.drivers.usb.UsbTimeoutException;

public class UsbComm {
    public static final int DEV_SPEED_UNDEFINED = 0;
    public static final int DEV_SPEED_UNKNOWN = 1;
    public static final int DEV_SPEED_LOW = 2;
    public static final int DEV_SPEED_FULL = 3;
    public static final int DEV_CLASS_INTERFACE = 0;
    public static final int DEV_CLASS_CDC_CTRL = 2;
    public static final int DEV_CLASS_HUB = 9;
    public static final int DEV_CLASS_DIAGNOSTIC = 220;
    public static final int DEV_CLASS_MISC = 239;
    public static final int DEV_CLASS_VENDOR_SPEC = 255;
    public static final int CFG_ATTR_SELF_POWER = 64;
    public static final int CFG_ATTR_REMOTE_WAKE = 32;
    public static final int IFC_CLASS_AUDIO = 1;
    public static final int IFC_CLASS_CDC_CTRL = 2;
    public static final int IFC_CLASS_HID = 3;
    public static final int IFC_CLASS_PHYSICAL = 5;
    public static final int IFC_CLASS_IMAGE = 6;
    public static final int IFC_CLASS_PRINTER = 7;
    public static final int IFC_CLASS_MASS_STORE = 8;
    public static final int IFC_CLASS_CDC_DATA = 10;
    public static final int IFC_CLASS_SMART_CARD = 11;
    public static final int IFC_CLASS_CONTENT_SEC = 13;
    public static final int IFC_CLASS_VIDEO = 14;
    public static final int IFC_CLASS_HEALTHCARE = 15;
    public static final int IFC_CLASS_DIAGNOSTIC = 220;
    public static final int IFC_CLASS_WIRELESS = 224;
    public static final int IFC_CLASS_MISC = 239;
    public static final int IFC_CLASS_APP_SPEC = 254;
    public static final int IFC_CLASS_VENDOR_SPEC = 255;
    public static final int EP_ATTR_CONTROL = 0;
    public static final int EP_ATTR_ISOCHRONOUS = 1;
    public static final int EP_ATTR_BULK = 2;
    public static final int EP_ATTR_INTERRUPT = 3;
    private static UsbHub rootHub;
    private UsbDevice dev;
    private final Listener listener = new Listener();

    public UsbComm() throws UsbException {
        if (rootHub == null) {
            rootHub = UsbHostManager.getUsbServices().getRootUsbHub();
        }
    }

    public static List findDevices(int vid, int pid, String serial) throws UsbException {
        if (rootHub == null) {
            rootHub = UsbHostManager.getUsbServices().getRootUsbHub();
        }
        ArrayList list = new ArrayList();
        UsbComm.find(rootHub, vid, pid, serial, list);
        return list;
    }

    public UsbDevice findDevice(int vid, int pid) throws UsbException {
        return this.findDevice(vid, pid, null, 0);
    }

    public UsbDevice findDevice(int vid, int pid, String serial) throws UsbException {
        return this.findDevice(vid, pid, serial, 0);
    }

    public UsbDevice findDevice(int vid, int pid, int index) throws UsbException {
        return this.findDevice(vid, pid, null, index);
    }

    public UsbDevice findDevice(int vid, int pid, String serial, int index) throws UsbException {
        UsbDevice devc = null;
        if (vid != -1 && pid != -1) {
            ArrayList list = new ArrayList();
            UsbComm.find(rootHub, vid, pid, serial, list);
            devc = list.size() <= index ? null : (UsbDevice)list.get(index);
        }
        this.setDevice(devc);
        return devc;
    }

    public UsbDevice getDevice() {
        return this.dev;
    }

    public void setDevice(UsbDevice device) throws UsbException {
        if (this.dev != null) {
            this.dev.removeUsbDeviceListener(this.listener);
        }
        this.dev = device;
        if (this.dev != null) {
            this.dev.addUsbDeviceListener(this.listener);
        }
    }

    public UsbConfiguration getConfiguration() {
        return this.dev != null ? this.dev.getActiveUsbConfiguration() : null;
    }

    public void setConfiguration(int cfgNum) throws UsbException {
        this.checkDevice();
        StandardRequest.setConfiguration(this.dev, (short)cfgNum);
    }

    public UsbInterface getInterface(int iface) {
        if (this.dev != null) {
            return null;
        }
        UsbConfiguration cfg = this.dev.getActiveUsbConfiguration();
        if (cfg == null) {
            return null;
        }
        UsbInterface ifc = cfg.getUsbInterface((byte)iface);
        return ifc != null ? ifc.getActiveSetting() : null;
    }

    public static UsbInterface getInterface(UsbDevice device, int iface) {
        UsbConfiguration cfg = device.getActiveUsbConfiguration();
        if (cfg == null) {
            return null;
        }
        UsbInterface ifc = cfg.getUsbInterface((byte)iface);
        return ifc != null ? ifc.getActiveSetting() : null;
    }

    public void setInterface(int iface, int setting) throws UsbException {
        this.checkDevice();
        StandardRequest.setInterface(this.dev, (short)iface, (short)setting);
    }

    public static UsbEndpoint getEndpoint(UsbInterface iface, int epAddr) {
        return iface.getUsbEndpoint((byte)epAddr);
    }

    public static List getEndpoints(UsbInterface iface) {
        return iface.getUsbEndpoints();
    }

    public int getSpeed() {
        return this.dev != null ? UsbComm.getSpeed(this.dev) : 0;
    }

    public static int getSpeed(UsbDevice device) {
        Object speed = device.getSpeed();
        if (speed.equals(UsbConst.DEVICE_SPEED_UNKNOWN)) {
            return 1;
        }
        if (speed.equals(UsbConst.DEVICE_SPEED_LOW)) {
            return 2;
        }
        if (speed.equals(UsbConst.DEVICE_SPEED_FULL)) {
            return 3;
        }
        return 0;
    }

    public void claim(int iface, boolean force) throws UsbException {
        this.checkDevice();
        UsbConfiguration cfg = this.dev.getActiveUsbConfiguration();
        if (cfg == null) {
            throw new UsbException("Device not configured");
        }
        UsbInterface ifc = cfg.getUsbInterface((byte)iface);
        if (ifc != null) {
            ifc = ifc.getActiveSetting();
        }
        if (ifc == null) {
            throw new UsbException("Interface not found");
        }
        ifc.claim(new Policy(force));
    }

    public void release(int iface) throws UsbException {
        this.checkDevice();
        UsbConfiguration cfg = this.dev.getActiveUsbConfiguration();
        UsbInterface ifc = cfg.getUsbInterface((byte)iface).getActiveSetting();
        if (ifc == null) {
            throw new UsbException("Interface not found");
        }
        ifc.release();
    }

    public UsbCommPipe open(int iface, int epAddr) throws UsbException {
        this.checkDevice();
        UsbConfiguration cfg = this.dev.getActiveUsbConfiguration();
        UsbInterface ifc = cfg.getUsbInterface((byte)iface).getActiveSetting();
        if (ifc == null) {
            throw new UsbException("Interface not found");
        }
        UsbEndpoint ep = ifc.getUsbEndpoint((byte)epAddr);
        if (ep == null) {
            throw new UsbException("Endpoint not found");
        }
        return new UsbCommPipe(ep.getUsbPipe());
    }

    public int write(int type, int rqst, int value, int index, byte[] data) throws UsbException {
        return this.write(type, rqst, value, index, data, 0, data.length);
    }

    public int write(int type, int rqst, int value, int index, byte[] data, int offs, int leng) throws UsbException {
        this.checkDevice();
        if ((type & 0x80) != 0) {
            throw new UsbException("Cannot write to IN endpoint");
        }
        UsbControlIrp irp = this.dev.createUsbControlIrp((byte)type, (byte)rqst, (short)value, (short)index);
        irp.setData(data, offs, leng);
        irp.setComplete(false);
        irp.setUsbException(null);
        this.dev.syncSubmit(irp);
        return irp.getActualLength();
    }

    public int read(int type, int rqst, int value, int index, byte[] data, int timeout) throws UsbException, UsbTimeoutException {
        return this.read(type, rqst, value, index, data, 0, data.length, timeout);
    }

    public int read(int type, int rqst, int value, int index, byte[] data, int offs, int leng, int timeout) throws UsbException, UsbTimeoutException {
        this.checkDevice();
        if ((type & 0x80) == 0) {
            throw new UsbException("Cannot read from OUT endpoint");
        }
        UsbControlIrp irp = this.dev.createUsbControlIrp((byte)type, (byte)rqst, (short)value, (short)index);
        irp.setData(data, offs, leng);
        irp.setComplete(false);
        irp.setUsbException(null);
        if (timeout == 0) {
            this.dev.syncSubmit(irp);
        } else {
            Thread.interrupted();
            this.listener.mainThread = Thread.currentThread();
            this.listener.irp = irp;
            try {
                this.dev.asyncSubmit(irp);
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                this.listener.irp = null;
            }
        }
        UsbException re = irp.getUsbException();
        if (re != null) {
            throw re;
        }
        if (!irp.isComplete()) {
            throw new UsbTimeoutException();
        }
        return irp.getActualLength();
    }

    private static void find(UsbHub hub, int vid, int pid, String serial, List list) throws UsbException {
        int nPort = hub.getNumberOfPorts() & 0xFF;
        int j = 1;
        while (j <= nPort) {
            UsbDevice dev = hub.getUsbPort((byte)j).getUsbDevice();
            if (dev != null) {
                if (dev.isUsbHub()) {
                    UsbComm.find((UsbHub)dev, vid, pid, serial, list);
                } else {
                    UsbDeviceDescriptor desc = dev.getUsbDeviceDescriptor();
                    if (!(vid != -1 && (short)vid != desc.idVendor() || pid != -1 && (short)pid != desc.idProduct())) {
                        if (serial == null) {
                            list.add(dev);
                        } else {
                            String serno = dev.getSerialNumberString();
                            if (serno != null && serno.equals(serial)) {
                                list.add(dev);
                            }
                        }
                    }
                }
            }
            ++j;
        }
    }

    private void checkDevice() throws UsbException {
        if (this.dev == null) {
            throw new UsbException("Device has not been set");
        }
    }

    static class Listener
    implements UsbDeviceListener {
        private Thread mainThread = null;
        private UsbControlIrp irp = null;

        Listener() {
        }

        @Override
        public void dataEventOccurred(UsbDeviceDataEvent event) {
            if (event.getUsbControlIrp().equals(this.irp)) {
                this.mainThread.interrupt();
            }
        }

        @Override
        public void errorEventOccurred(UsbDeviceErrorEvent event) {
            if (event.getUsbControlIrp().equals(this.irp)) {
                this.mainThread.interrupt();
            }
        }

        @Override
        public void usbDeviceDetached(UsbDeviceEvent event) {
        }
    }

    static class Policy
    implements UsbInterfacePolicy {
        private final boolean force;

        public Policy(boolean force) {
            this.force = force;
        }

        @Override
        public boolean forceClaim(UsbInterface iface) {
            return this.force;
        }
    }
}

