/*
 * Decompiled with CFR 0.152.
 */
package com.mcreations.usb.windows;

import com.ibm.jusb.UsbConfigurationDescriptorImp;
import com.ibm.jusb.UsbConfigurationImp;
import com.ibm.jusb.UsbControlPipeImp;
import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbEndpointDescriptorImp;
import com.ibm.jusb.UsbEndpointImp;
import com.ibm.jusb.UsbHubImp;
import com.ibm.jusb.UsbInterfaceDescriptorImp;
import com.ibm.jusb.UsbInterfaceImp;
import com.ibm.jusb.UsbPipeImp;
import com.ibm.jusb.UsbPortImp;
import com.mcreations.usb.windows.Mutex;
import com.mcreations.usb.windows.WindowsDeviceOsImp;
import com.mcreations.usb.windows.WindowsHubOsImp;
import com.mcreations.usb.windows.WindowsInterfaceOsImp;
import com.mcreations.usb.windows.WindowsPipeOsImp;
import com.mcreations.usb.windows.WindowsUsbServices;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.usb.UsbConst;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEncodingException;
import javax.usb.UsbException;
import net.sf.libusb.Libusb;
import net.sf.libusb.usb_bus;
import net.sf.libusb.usb_config_descriptor;
import net.sf.libusb.usb_device;
import net.sf.libusb.usb_endpoint_descriptor;
import net.sf.libusb.usb_interface;
import net.sf.libusb.usb_interface_descriptor;
import org.apache.log4j.Logger;

class JavaxUsb {
    public static final String VERSION = "0.9.0";
    private static boolean initialised;
    private static Logger log;
    private static Mutex mutex;
    private static boolean libraryLoaded;
    private static Hashtable msgLevelTable;
    private static int traceLevel;
    public static final String LIBRARY_NAME = "usbJNI";
    public static final String ERROR_WHILE_LOADING_SHARED_LIBRARY = "Error while loading shared library";
    public static final String EXCEPTION_WHILE_LOADING_SHARED_LIBRARY = "Exception while loading shared library";
    public static final String LOG_DEFAULT = "default";
    public static final String LOG_XFER = "xfer";
    public static final String LOG_HOTPLUG = "hotplug";
    public static final String LOG_URB = "urb";
    private static final String CLASS = "JavaxUsb";
    public static final int CRITICAL = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int FUNC = 3;
    public static final int DEBUG = 4;
    public static final int OTHER = 5;
    public static final int REQUEST_PIPE = 1;
    public static final int REQUEST_SET_INTERFACE = 2;
    public static final int REQUEST_SET_CONFIGURATION = 3;
    public static final int REQUEST_CLAIM_INTERFACE = 4;
    public static final int REQUEST_IS_CLAIMED_INTERFACE = 5;
    public static final int REQUEST_RELEASE_INTERFACE = 6;
    public static final int REQUEST_ISOCHRONOUS = 7;
    static final int PIPE_CONTROL = 1;
    static final int PIPE_BULK = 2;
    static final int PIPE_INTERRUPT = 3;
    static final int PIPE_ISOCHRONOUS = 4;

    static {
        log = Logger.getLogger(JavaxUsb.class);
        mutex = new Mutex();
        libraryLoaded = false;
        msgLevelTable = new Hashtable();
    }

    JavaxUsb() {
    }

    public static void log(String logname, int level, String file, String func, String msg) {
        switch (level) {
            case 0: {
                log.fatal((Object)(String.valueOf(func) + "() " + msg));
                break;
            }
            case 1: {
                log.error((Object)(String.valueOf(func) + "() " + msg));
                break;
            }
            case 2: {
                log.info((Object)(String.valueOf(func) + "() " + msg));
                break;
            }
            case 3: {
                log.trace((Object)(String.valueOf(func) + "() " + msg));
                break;
            }
            case 4: {
                log.debug((Object)(String.valueOf(func) + "() " + msg));
                break;
            }
            default: {
                log.debug((Object)(String.valueOf(func) + "() " + msg));
            }
        }
    }

    public static void initialise() throws UsbException {
        String method = "initialise";
        JavaxUsb.log(LOG_HOTPLUG, 3, CLASS, method, "Entering initialise");
        if (initialised) {
            JavaxUsb.log(LOG_HOTPLUG, 3, CLASS, method, "Already initialised. Leaving initialise");
            return;
        }
        JavaxUsb.loadLibrary();
        mutex.acquire();
        try {
            Libusb.usb_init();
            if (traceLevel >= 5) {
                Libusb.usb_set_debug(255);
            }
        }
        finally {
            mutex.release();
        }
        initialised = true;
    }

    private static void loadLibrary() throws UsbException {
        if (libraryLoaded) {
            return;
        }
        try {
            JavaxUsb.log(LOG_HOTPLUG, 3, CLASS, "loadLibrary", "Getting java.library.path");
            System.loadLibrary(LIBRARY_NAME);
        }
        catch (Exception e) {
            throw new UsbException("Exception while loading shared library <" + System.mapLibraryName(LIBRARY_NAME) + "> : \n" + e.getMessage());
        }
        catch (Error e) {
            throw new UsbException("Error while loading shared library <" + System.mapLibraryName(LIBRARY_NAME) + "> : \n" + e.getMessage());
        }
    }

    public static void isReturnCodeError(int error) throws UsbException, UsbDisconnectedException {
        if (error >= 0) {
            return;
        }
        if (error == -19) {
            throw new UsbDisconnectedException("libusb reports device has been disconnected: " + error + ", " + Libusb.usb_strerror());
        }
        throw JavaxUsb.errorToUsbException(error);
    }

    public static UsbException errorToUsbException(int error) {
        return new UsbException(JavaxUsb.nativeGetErrorMessage(error));
    }

    public static UsbException errorToUsbException(int error, String string) {
        return new UsbException(String.valueOf(string) + " : " + JavaxUsb.nativeGetErrorMessage(error));
    }

    static native int nativeTopologyListener(WindowsUsbServices var0);

    static String nativeGetErrorMessage(int error) {
        return Libusb.usb_strerror();
    }

    private static void attachParentUsbPort(UsbHubImp hub, UsbDeviceImp device) {
        List ports = hub.getUsbPorts();
        for (UsbPortImp usbPortImp : ports) {
            if (usbPortImp.isUsbDeviceAttached()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"attachParentUsbPort(), found empty port");
            }
            device.setParentUsbPortImp(usbPortImp);
            usbPortImp.attachUsbDeviceImp(device);
            return;
        }
        byte port = hub.getNumberOfPorts();
        UsbPortImp usbPortImp = hub.getUsbPortImp(port = (byte)(port + 1));
        if (usbPortImp == null) {
            log.debug((Object)("attachParentUsbPort(), WARNING resizing hub to " + port + " ports"));
            hub.resize(port);
            usbPortImp = hub.getUsbPortImp(port);
        }
        usbPortImp.attachUsbDeviceImp(device);
        device.setParentUsbPortImp(usbPortImp);
    }

    protected static boolean isUsbDevicesEqual(UsbDeviceImp dev1, UsbDeviceImp dev2) {
        block10: {
            UsbDeviceDescriptor desc2;
            UsbDeviceDescriptor desc1;
            block9: {
                block8: {
                    desc1 = dev1.getUsbDeviceDescriptor();
                    desc2 = dev2.getUsbDeviceDescriptor();
                    if (dev1.isUsbHub() == dev2.isUsbHub()) break block8;
                    return false;
                }
                if (dev1.getSpeed() == dev2.getSpeed()) break block9;
                return false;
            }
            if (desc1.equals(desc2)) break block10;
            return false;
        }
        try {
            return dev1.getSerialNumberString().equals(dev2.getSerialNumberString());
        }
        catch (UsbEncodingException usbEncodingException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (UsbDisconnectedException usbDisconnectedException) {
            log.debug((Object)"isUsbDevicesEqual() device no longer exists");
            return false;
        }
        catch (UsbException usbException) {
            return false;
        }
    }

    private static void checkUsbDeviceImp(UsbHubImp hub, UsbDeviceImp device, List currentDevices, List connected) {
        boolean found = false;
        String method = "checkUsbDeviceImp";
        Iterator iterator = currentDevices.iterator();
        while (iterator.hasNext()) {
            UsbDeviceImp usbDeviceFromList = (UsbDeviceImp)iterator.next();
            if (!JavaxUsb.isUsbDevicesEqual(usbDeviceFromList, device)) continue;
            iterator.remove();
            found = true;
        }
        if (!found) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(String.valueOf(method) + " found new device"));
            }
            connected.add(device);
            JavaxUsb.attachParentUsbPort(hub, device);
        }
    }

    static int nativeTopologyUpdater(WindowsUsbServices services, List connectedDevices, List disconnectedDevices) {
        String method = "nativeTopologyUpdater()";
        UsbHubImp rootHub = services.getRootUsbHubImp();
        if (rootHub == null) {
            throw new RuntimeException("The (virtual) root hub couldn't be retrieved.");
        }
        mutex.acquire();
        try {
            int busCount = Libusb.usb_find_busses();
            int deviceCount = Libusb.usb_find_devices();
            if (log.isDebugEnabled()) {
                log.debug((Object)(String.valueOf(method) + "   Found " + busCount + " new busses. and " + deviceCount + " new devices."));
            }
            if (deviceCount == 0) {
                return 0;
            }
            usb_bus libusb_bus = Libusb.usb_get_busses();
            while (libusb_bus != null) {
                log.debug((Object)"");
                log.debug((Object)(String.valueOf(method) + " Scanning bus " + libusb_bus.getDirname()));
                usb_device libusb_dev = libusb_bus.getDevices();
                while (libusb_dev != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(String.valueOf(method) + " Device: " + libusb_dev.getFilename()));
                    }
                    if (libusb_dev.getConfig() == null) {
                        JavaxUsb.log(LOG_HOTPLUG, 1, CLASS, method, "Couldn't retrieve descriptors for device '" + libusb_bus.getDirname() + "/" + libusb_dev.getFilename() + "'");
                        libusb_dev = libusb_dev.getNext();
                        continue;
                    }
                    UsbDeviceImp usbDev = JavaxUsb.buildDevice(libusb_dev, libusb_bus);
                    JavaxUsb.checkUsbDeviceImp(rootHub, usbDev, disconnectedDevices, connectedDevices);
                    libusb_dev = libusb_dev.getNext();
                }
                libusb_bus = libusb_bus.getNext();
            }
        }
        finally {
            mutex.release();
        }
        return -1;
    }

    private static void buildEndpoint(UsbInterfaceImp iface, usb_endpoint_descriptor endPointDesc) {
        UsbEndpointDescriptorImp desc = new UsbEndpointDescriptorImp((byte)endPointDesc.getBLength(), (byte)endPointDesc.getBDescriptorType(), (byte)endPointDesc.getBEndpointAddress(), (byte)endPointDesc.getBmAttributes(), (byte)endPointDesc.getBInterval(), (short)endPointDesc.getWMaxPacketSize());
        UsbEndpointImp ep = new UsbEndpointImp(iface, desc);
        UsbPipeImp pipe = null;
        WindowsInterfaceOsImp windowsInterfaceOsImp = (WindowsInterfaceOsImp)iface.getUsbInterfaceOsImp();
        switch (ep.getType()) {
            case 0: {
                pipe = new UsbControlPipeImp(ep, null);
                pipe.setUsbPipeOsImp(new WindowsPipeOsImp(pipe, windowsInterfaceOsImp));
                break;
            }
            case 1: {
                pipe = new UsbPipeImp(ep, null);
                pipe.setUsbPipeOsImp(new WindowsPipeOsImp(pipe, windowsInterfaceOsImp));
                break;
            }
            case 2: {
                pipe = new UsbPipeImp(ep, null);
                pipe.setUsbPipeOsImp(new WindowsPipeOsImp(pipe, windowsInterfaceOsImp));
                break;
            }
            case 3: {
                pipe = new UsbPipeImp(ep, null);
                pipe.setUsbPipeOsImp(new WindowsPipeOsImp(pipe, windowsInterfaceOsImp));
                break;
            }
            default: {
                String emsg = "Invalid UsbEndpoint type " + ep.getType();
                log.error((Object)("buildEndpoint() " + emsg));
                throw new RuntimeException(emsg);
            }
        }
    }

    private static void buildInterface(UsbConfigurationImp usbConfig, usb_interface_descriptor ifaceDesc) {
        boolean active;
        UsbInterfaceDescriptorImp desc = new UsbInterfaceDescriptorImp((byte)ifaceDesc.getBLength(), (byte)ifaceDesc.getBDescriptorType(), (byte)ifaceDesc.getBInterfaceNumber(), (byte)ifaceDesc.getBAlternateSetting(), (byte)ifaceDesc.getBNumEndpoints(), (byte)ifaceDesc.getBInterfaceClass(), (byte)ifaceDesc.getBInterfaceSubClass(), (byte)ifaceDesc.getBInterfaceProtocol(), (byte)ifaceDesc.getIInterface());
        UsbInterfaceImp iface = new UsbInterfaceImp(usbConfig, desc);
        boolean bl = active = ifaceDesc.getBAlternateSetting() == 0;
        if (usbConfig.isActive() && active) {
            iface.setActiveSettingNumber(iface.getUsbInterfaceDescriptor().bAlternateSetting());
        } else {
            JavaxUsb.log(LOG_HOTPLUG, 3, CLASS, "buildInterface", "inteface not active");
        }
        WindowsDeviceOsImp windowsDeviceOsImp = (WindowsDeviceOsImp)iface.getUsbConfigurationImp().getUsbDeviceImp();
        WindowsInterfaceOsImp windowsInterfaceOsImp = new WindowsInterfaceOsImp(iface, windowsDeviceOsImp);
        iface.setUsbInterfaceOsImp(windowsInterfaceOsImp);
        int i = 0;
        while (i < ifaceDesc.getBNumEndpoints()) {
            JavaxUsb.buildEndpoint(iface, Libusb.usb_endpoint_descriptor_index(ifaceDesc.getEndpoint(), i));
            ++i;
        }
    }

    private static void buildConfig(UsbDeviceImp usbDev, usb_config_descriptor config) {
        UsbConfigurationDescriptorImp desc = new UsbConfigurationDescriptorImp((byte)config.getBLength(), (byte)config.getBDescriptorType(), (short)config.getWTotalLength(), (byte)config.getBNumInterfaces(), (byte)config.getBConfigurationValue(), (byte)config.getIConfiguration(), (byte)config.getBmAttributes(), (byte)config.getMaxPower());
        UsbConfigurationImp usbConfig = new UsbConfigurationImp(usbDev, desc);
        usbDev.addUsbConfigurationImp(usbConfig);
        if (config.getBConfigurationValue() == 1) {
            config.setIConfiguration((short)1);
            usbDev.setActiveUsbConfigurationNumber((byte)config.getBConfigurationValue());
        }
        int i = 0;
        while (i < config.getBNumInterfaces()) {
            usb_interface iface = Libusb.usb_interface_index(config.get_interface(), i);
            int j = 0;
            while (j < iface.getNum_altsetting()) {
                usb_interface_descriptor ifaceDesc = Libusb.usb_interface_descriptor_index(iface.getAltsetting(), j);
                JavaxUsb.buildInterface(usbConfig, ifaceDesc);
                ++j;
            }
            ++i;
        }
    }

    static UsbDeviceImp buildDevice(usb_device dev, usb_bus bus) {
        WindowsDeviceOsImp usbDev;
        if (dev.getDescriptor().getBDeviceClass() == Libusb.USB_CLASS_HUB) {
            usbDev = new WindowsHubOsImp(dev);
        } else {
            usbDev = new WindowsDeviceOsImp(dev);
            usbDev.setSpeed(UsbConst.DEVICE_SPEED_UNKNOWN);
            int i = 0;
            while (i < dev.getDescriptor().getBNumConfigurations()) {
                JavaxUsb.buildConfig(usbDev, Libusb.usb_config_descriptor_index(dev.getConfig(), i));
                ++i;
            }
        }
        return usbDev;
    }

    static String bytes2String(byte[] buf) {
        int i = 0;
        while (i < buf.length) {
            if (buf[i] == 0) break;
            ++i;
        }
        return new String(buf, 0, i);
    }

    public static void connectUsbDeviceImp(UsbHubImp hub, int port, UsbDeviceImp device) {
        try {
            JavaxUsb.log(LOG_HOTPLUG, 4, CLASS, "connectUsbDeviceImp", "device connect : ");
            device.connect(hub, (byte)port);
        }
        catch (UsbException uE) {
            JavaxUsb.log(LOG_HOTPLUG, 1, CLASS, "connectUsbDeviceImp", "UsbException while connecting : " + uE.toString());
        }
    }

    static void setTraceLevel(int level) {
        traceLevel = level;
    }

    static void setTraceType(boolean enable, String type) {
        msgLevelTable.put(type, enable ? Boolean.TRUE : Boolean.FALSE);
    }

    static void setTracing(boolean enable) {
    }

    public static int getIoTimeout() {
        return 5000;
    }

    static Mutex getMutex() {
        return mutex;
    }
}

