/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbHubImp;
import javax.usb.UsbDevice;
import javax.usb.UsbHub;
import javax.usb.UsbPort;

public class UsbPortImp
implements UsbPort {
    private byte portNumber = 0;
    private UsbHubImp usbHubImp = null;
    private UsbDeviceImp usbDeviceImp = null;
    private static final String USB_PORT_DEVICE_ALREADY_ATTACHED = "UsbPort already has a UsbDeviceImp attached";
    private static final String USB_PORT_DEVICE_NOT_ATTACHED = "Specified UsbDeviceImp not attached";

    public UsbPortImp(UsbHubImp hub, byte number) {
        this.usbHubImp = hub;
        this.portNumber = number;
    }

    @Override
    public byte getPortNumber() {
        return this.portNumber;
    }

    @Override
    public UsbHub getUsbHub() {
        return this.getUsbHubImp();
    }

    public UsbHubImp getUsbHubImp() {
        return this.usbHubImp;
    }

    @Override
    public boolean isUsbDeviceAttached() {
        return this.getUsbDevice() != null;
    }

    @Override
    public UsbDevice getUsbDevice() {
        return this.getUsbDeviceImp();
    }

    public UsbDeviceImp getUsbDeviceImp() {
        return this.usbDeviceImp;
    }

    public synchronized void attachUsbDeviceImp(UsbDeviceImp device) throws IllegalArgumentException {
        if (this.isUsbDeviceAttached()) {
            throw new IllegalArgumentException(USB_PORT_DEVICE_ALREADY_ATTACHED);
        }
        this.usbDeviceImp = device;
    }

    public synchronized void detachUsbDeviceImp(UsbDeviceImp device) throws IllegalArgumentException {
        try {
            if (!this.getUsbDeviceImp().equals(device)) {
                throw new IllegalArgumentException(USB_PORT_DEVICE_NOT_ATTACHED);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException(USB_PORT_DEVICE_NOT_ATTACHED);
        }
        this.usbDeviceImp = null;
    }
}

