/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import javax.usb.UsbBabbleException;
import javax.usb.UsbException;
import javax.usb.UsbIrp;
import javax.usb.UsbPipe;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;
import org.lsst.ccs.drivers.usb.UsbTimeoutException;

public class UsbCommPipe {
    private UsbPipe pipe;
    private boolean input;
    private final Listener listener = new Listener();
    private Thread exitHook = new Thread(){

        @Override
        public void run() {
            try {
                UsbCommPipe.this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public UsbCommPipe(UsbPipe pipe) throws UsbException {
        this.pipe = pipe;
        this.input = pipe.getUsbEndpoint().getDirection() != 0;
        pipe.addUsbPipeListener(this.listener);
        pipe.open();
        Runtime.getRuntime().addShutdownHook(this.exitHook);
    }

    public void close() throws UsbException {
        if (this.input) {
            this.flush();
        }
        this.pipe.close();
        Runtime.getRuntime().removeShutdownHook(this.exitHook);
    }

    public int write(byte[] data) throws UsbException {
        return this.write(data, 0, data.length);
    }

    public int write(byte[] data, int offs, int leng) throws UsbException {
        if (this.input) {
            throw new UsbException("Cannot write to IN endpoint");
        }
        UsbIrp irp = this.pipe.createUsbIrp();
        irp.setData(data, offs, leng);
        irp.setComplete(false);
        irp.setUsbException(null);
        this.pipe.syncSubmit(irp);
        return irp.getActualLength();
    }

    public int read(byte[] data, int timeout) throws UsbException, UsbTimeoutException {
        return this.read(data, 0, data.length, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] data, int offs, int leng, int timeout) throws UsbException, UsbTimeoutException {
        if (!this.input) {
            throw new UsbException("Cannot read from OUT endpoint");
        }
        UsbIrp irp = this.pipe.createUsbIrp();
        irp.setData(data, offs, leng);
        irp.setComplete(false);
        irp.setUsbException(null);
        if (timeout == 0) {
            this.pipe.syncSubmit(irp);
        } else {
            Thread.interrupted();
            this.listener.mainThread = Thread.currentThread();
            this.listener.irp = irp;
            try {
                this.pipe.asyncSubmit(irp);
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            finally {
                this.listener.irp = null;
            }
        }
        UsbException re = irp.getUsbException();
        if (re != null) {
            throw re;
        }
        if (!irp.isComplete()) {
            try {
                this.pipe.abortAllSubmissions();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new UsbTimeoutException();
        }
        return irp.getActualLength();
    }

    public int flush() throws UsbException {
        int leng = 0;
        byte[] data = new byte[64];
        while (true) {
            try {
                while (true) {
                    leng += this.read(data, 100);
                }
            }
            catch (UsbTimeoutException e) {
            }
            catch (UsbBabbleException e) {
                data = new byte[2 * data.length];
                continue;
            }
            break;
        }
        return leng;
    }

    static class Listener
    implements UsbPipeListener {
        private Thread mainThread = null;
        private UsbIrp irp = null;

        Listener() {
        }

        @Override
        public void dataEventOccurred(UsbPipeDataEvent event) {
            if (event.getUsbIrp().equals(this.irp)) {
                this.mainThread.interrupt();
            }
        }

        @Override
        public void errorEventOccurred(UsbPipeErrorEvent event) {
            if (event.getUsbIrp().equals(this.irp)) {
                this.mainThread.interrupt();
            }
        }
    }
}

