/*
 * Decompiled with CFR 0.152.
 */
package javax.usb.examples;

import java.util.List;
import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbPort;
import javax.usb.UsbServices;

public class ShowTopology {
    public static final String PREFIX = "  ";

    public static void main(String[] argv) {
        UsbHub virtualRootUsbHub = ShowTopology.getVirtualRootUsbHub();
        System.out.println("Using UsbHub.getAttachedUsbDevices() to show toplogy:");
        ShowTopology.processUsingGetAttachedUsbDevices(virtualRootUsbHub, "");
        System.out.println("Using UsbHub.getUsbPorts() to show toplogy:");
        ShowTopology.processUsingGetUsbPorts(virtualRootUsbHub, "");
    }

    public static UsbHub getVirtualRootUsbHub() {
        UsbServices services = null;
        UsbHub virtualRootUsbHub = null;
        try {
            services = UsbHostManager.getUsbServices();
        }
        catch (UsbException uE) {
            uE.printStackTrace();
            throw new RuntimeException("Error : " + uE.getMessage());
        }
        catch (SecurityException sE) {
            throw new RuntimeException("Error : " + sE.getMessage());
        }
        try {
            virtualRootUsbHub = services.getRootUsbHub();
        }
        catch (UsbException uE) {
            throw new RuntimeException("Error : " + uE.getMessage());
        }
        catch (SecurityException sE) {
            throw new RuntimeException("Error : " + sE.getMessage());
        }
        return virtualRootUsbHub;
    }

    public static void processUsingGetAttachedUsbDevices(UsbDevice usbDevice, String prefix) {
        UsbHub usbHub = null;
        if (!usbDevice.isUsbHub()) {
            System.out.println(prefix + "Device");
            return;
        }
        usbHub = (UsbHub)usbDevice;
        if (usbHub.isRootUsbHub()) {
            System.out.println(prefix + "Virtual root UsbHub");
        } else {
            System.out.println(prefix + "UsbHub");
        }
        List attachedUsbDevices = usbHub.getAttachedUsbDevices();
        for (int i = 0; i < attachedUsbDevices.size(); ++i) {
            UsbDevice device = (UsbDevice)attachedUsbDevices.get(i);
            ShowTopology.processUsingGetAttachedUsbDevices(device, prefix + PREFIX);
        }
    }

    public static void processUsingGetUsbPorts(UsbDevice usbDevice, String prefix) {
        UsbHub usbHub = null;
        if (!usbDevice.isUsbHub()) {
            System.out.println(prefix + "Device");
            return;
        }
        usbHub = (UsbHub)usbDevice;
        if (usbHub.isRootUsbHub()) {
            System.out.println(prefix + "Virtual root UsbHub");
        } else {
            System.out.println(prefix + "UsbHub");
        }
        List usbPorts = usbHub.getUsbPorts();
        for (int i = 0; i < usbPorts.size(); ++i) {
            UsbPort port = (UsbPort)usbPorts.get(i);
            if (!port.isUsbDeviceAttached()) {
                System.out.println(prefix + PREFIX + "UsbPort");
                continue;
            }
            ShowTopology.processUsingGetUsbPorts(port.getUsbDevice(), prefix + PREFIX);
        }
    }
}

