/*
 * Decompiled with CFR 0.152.
 */
package javax.usb.examples;

import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbDevice;
import javax.usb.UsbEncodingException;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.examples.ShowTopology;
import javax.usb.util.UsbUtil;

public class FindUsbDevice {
    private static short staticVendorId = (short)-1;
    private static short staticProductId = (short)-1;
    private static byte staticDeviceClass = (byte)9;
    private static String staticManufacturerString = "This probably won't match anything";
    private static final String VENDOR_ID_KEY = "idVendor";
    private static final String PRODUCT_ID_KEY = "idProduct";
    private static final String DEVICE_CLASS_KEY = "bDeviceClass";
    private static final String MANUFACTURER_STRING_KEY = "manufacturer";
    private static final String KEYS = "\tidVendor\n\tidProduct\n\tbDeviceClass\n\tmanufacturer";
    private static final String USAGE = "Usage : java FindUsbDevice <key=value>\n\n\tvalid keys are:\n\tidVendor\n\tidProduct\n\tbDeviceClass\n\tmanufacturer";

    public static void main(String[] argv) {
        FindUsbDevice.parseArgv(argv);
        UsbHub virtualRootUsbHub = ShowTopology.getVirtualRootUsbHub();
        List usbDevices = null;
        usbDevices = FindUsbDevice.getAllUsbDevices(virtualRootUsbHub);
        System.out.println("Found " + usbDevices.size() + " devices total.");
        usbDevices = FindUsbDevice.getUsbDevicesWithId(virtualRootUsbHub, FindUsbDevice.getVendorId(), FindUsbDevice.getProductId());
        System.out.print("Found " + usbDevices.size() + " devices with");
        System.out.print(" vendor ID 0x" + UsbUtil.toHexString(FindUsbDevice.getVendorId()));
        System.out.print(" product ID 0x" + UsbUtil.toHexString(FindUsbDevice.getProductId()));
        System.out.println("");
        usbDevices = FindUsbDevice.getUsbDevicesWithDeviceClass(virtualRootUsbHub, FindUsbDevice.getDeviceClass());
        System.out.print("Found " + usbDevices.size() + " devices with");
        System.out.print(" device class 0x" + UsbUtil.toHexString(FindUsbDevice.getDeviceClass()));
        System.out.println("");
        usbDevices = FindUsbDevice.getUsbDevicesWithManufacturerString(virtualRootUsbHub, FindUsbDevice.getManufacturerString());
        System.out.print("Found " + usbDevices.size() + " devices with");
        System.out.print(" manufacturer string \"" + FindUsbDevice.getManufacturerString() + "\"");
        System.out.println("");
    }

    public static List getAllUsbDevices(UsbDevice usbDevice) {
        ArrayList<UsbDevice> list = new ArrayList<UsbDevice>();
        list.add(usbDevice);
        if (usbDevice.isUsbHub()) {
            List devices = ((UsbHub)usbDevice).getAttachedUsbDevices();
            for (int i = 0; i < devices.size(); ++i) {
                list.addAll(FindUsbDevice.getAllUsbDevices((UsbDevice)devices.get(i)));
            }
        }
        return list;
    }

    public static List getUsbDevicesWithId(UsbDevice usbDevice, short vendorId, short productId) {
        ArrayList<UsbDevice> list = new ArrayList<UsbDevice>();
        if (vendorId == usbDevice.getUsbDeviceDescriptor().idVendor() && productId == usbDevice.getUsbDeviceDescriptor().idProduct()) {
            list.add(usbDevice);
        }
        if (usbDevice.isUsbHub()) {
            List devices = ((UsbHub)usbDevice).getAttachedUsbDevices();
            for (int i = 0; i < devices.size(); ++i) {
                list.addAll(FindUsbDevice.getUsbDevicesWithId((UsbDevice)devices.get(i), vendorId, productId));
            }
        }
        return list;
    }

    public static List getUsbDevicesWithDeviceClass(UsbDevice usbDevice, byte deviceClass) {
        ArrayList<UsbDevice> list = new ArrayList<UsbDevice>();
        if (deviceClass == usbDevice.getUsbDeviceDescriptor().bDeviceClass()) {
            list.add(usbDevice);
        }
        if (usbDevice.isUsbHub()) {
            List devices = ((UsbHub)usbDevice).getAttachedUsbDevices();
            for (int i = 0; i < devices.size(); ++i) {
                list.addAll(FindUsbDevice.getUsbDevicesWithDeviceClass((UsbDevice)devices.get(i), deviceClass));
            }
        }
        return list;
    }

    public static List getUsbDevicesWithManufacturerString(UsbDevice usbDevice, String manufacturerString) {
        ArrayList<UsbDevice> list = new ArrayList<UsbDevice>();
        try {
            if (manufacturerString.equals(usbDevice.getManufacturerString())) {
                list.add(usbDevice);
            }
        }
        catch (UsbException uE) {
            throw new RuntimeException("Couldn't get manufacturer string : " + uE.toString());
        }
        catch (UsbEncodingException usE) {
            // empty catch block
        }
        if (usbDevice.isUsbHub()) {
            List devices = ((UsbHub)usbDevice).getAttachedUsbDevices();
            for (int i = 0; i < devices.size(); ++i) {
                list.addAll(FindUsbDevice.getUsbDevicesWithManufacturerString((UsbDevice)devices.get(i), manufacturerString));
            }
        }
        return list;
    }

    public static short getVendorId() {
        return staticVendorId;
    }

    public static short getProductId() {
        return staticProductId;
    }

    public static byte getDeviceClass() {
        return staticDeviceClass;
    }

    public static String getManufacturerString() {
        return staticManufacturerString;
    }

    public static void parseArgv(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            int equalsIndex = argv[i].indexOf(61);
            try {
                String key = argv[i].substring(0, equalsIndex);
                String value = argv[i].substring(equalsIndex + 1);
                if (key.equals(VENDOR_ID_KEY)) {
                    staticVendorId = (short)Integer.decode(value).intValue();
                    continue;
                }
                if (key.equals(PRODUCT_ID_KEY)) {
                    staticProductId = (short)Integer.decode(value).intValue();
                    continue;
                }
                if (key.equals(DEVICE_CLASS_KEY)) {
                    staticDeviceClass = (byte)Integer.decode(value).intValue();
                    continue;
                }
                if (key.equals(MANUFACTURER_STRING_KEY)) {
                    staticManufacturerString = value;
                    continue;
                }
                System.err.println("Unrecognized key \"" + key + "\"\n" + USAGE);
                System.exit(1);
                continue;
            }
            catch (Exception e) {
                System.err.println("Invalid key-value pair \"" + argv[i] + "\"\n" + USAGE);
                System.exit(1);
            }
        }
    }
}

