/*
 * Decompiled with CFR 0.152.
 */
package javax.usb;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.usb.UsbException;
import javax.usb.UsbServices;

public final class UsbHostManager {
    public static final String JAVAX_USB_PROPERTIES_FILE = "javax.usb.properties";
    public static final String JAVAX_USB_USBSERVICES_PROPERTY = "javax.usb.services";
    private static final String PROPERTIES_FILE_NOT_FOUND = "Properties file javax.usb.properties not found.";
    private static final String PROPERTIES_FILE_IOEXCEPTION_READING = "IOException while reading properties file javax.usb.properties";
    private static final String PROPERTIES_FILE_IOEXCEPTION_CLOSING = "IOException while closing properties file javax.usb.properties";
    private static boolean propertiesLoaded = false;
    private static Properties properties = new Properties();
    private static Object propertiesLock = new Object();
    private static UsbServices usbServices = null;
    private static Object servicesLock = new Object();

    private UsbHostManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsbServices getUsbServices() throws UsbException, SecurityException {
        Object object = servicesLock;
        synchronized (object) {
            if (null == usbServices) {
                usbServices = UsbHostManager.createUsbServices();
            }
        }
        return usbServices;
    }

    public static Properties getProperties() throws UsbException, SecurityException {
        return UsbHostManager.getProperties(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(Properties userProperties) throws UsbException, SecurityException {
        Object object = propertiesLock;
        synchronized (object) {
            if (!propertiesLoaded) {
                UsbHostManager.setupProperties(userProperties);
            }
        }
        return (Properties)properties.clone();
    }

    private static UsbServices createUsbServices() throws UsbException, SecurityException {
        return UsbHostManager.createUsbServices(null);
    }

    private static UsbServices createUsbServices(Properties userProperties) throws UsbException, SecurityException {
        String className = UsbHostManager.getProperties(userProperties).getProperty(JAVAX_USB_USBSERVICES_PROPERTY);
        if (null == className) {
            throw new UsbException(UsbHostManager.USBSERVICES_PROPERTY_NOT_DEFINED());
        }
        try {
            return (UsbServices)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfE) {
            throw new UsbException(UsbHostManager.USBSERVICES_CLASSNOTFOUNDEXCEPTION(className) + " : " + cnfE.getMessage());
        }
        catch (ExceptionInInitializerError eiiE) {
            throw new UsbException(UsbHostManager.USBSERVICES_EXCEPTIONININITIALIZERERROR(className) + " : " + eiiE.getMessage());
        }
        catch (InstantiationException iE) {
            throw new UsbException(UsbHostManager.USBSERVICES_INSTANTIATIONEXCEPTION(className) + " : " + iE.getMessage());
        }
        catch (IllegalAccessException iaE) {
            throw new UsbException(UsbHostManager.USBSERVICES_ILLEGALACCESSEXCEPTION(className) + " : " + iaE.getMessage());
        }
        catch (ClassCastException ccE) {
            throw new UsbException(UsbHostManager.USBSERVICES_CLASSCASTEXCEPTION(className) + " : " + ccE.getMessage());
        }
    }

    private static void setupProperties(Properties userProperties) throws UsbException, SecurityException {
        String[] prefixes;
        InputStream i = null;
        String osPrefix = System.getProperty("os.name").startsWith("Win") ? "windows." : "linux.";
        for (String prefix : prefixes = new String[]{osPrefix, "/user."}) {
            String propFile = prefix + JAVAX_USB_PROPERTIES_FILE;
            i = UsbHostManager.class.getResourceAsStream(propFile);
            if (i == null) continue;
            try {
                properties.load(i);
                propertiesLoaded = true;
                System.out.println("Properties loaded from " + propFile);
            }
            catch (IOException ioE) {
                throw new UsbException("IOException while reading properties file javax.usb.properties : " + ioE.getMessage());
            }
            try {
                i.close();
            }
            catch (IOException ioE) {
                System.err.println("IOException while closing properties file javax.usb.properties : " + ioE.getMessage());
            }
        }
        if (userProperties != null) {
            for (String string : userProperties.keySet()) {
                properties.put(string, userProperties.getProperty(string));
            }
        }
        if (!propertiesLoaded) {
            System.out.println("No properties file found");
        }
    }

    private static final String USBSERVICES_PROPERTY_NOT_DEFINED() {
        return "The property javax.usb.services is not defined as the implementation class of UsbServices";
    }

    private static final String USBSERVICES_CLASSNOTFOUNDEXCEPTION(String c) {
        return "The UsbServices implementation class " + c + " was not found";
    }

    private static final String USBSERVICES_EXCEPTIONININITIALIZERERROR(String c) {
        return "an Exception occurred during initialization of the UsbServices Class " + c;
    }

    private static final String USBSERVICES_INSTANTIATIONEXCEPTION(String c) {
        return "An Exception occurred during instantiation of the UsbServices implementation " + c;
    }

    private static final String USBSERVICES_ILLEGALACCESSEXCEPTION(String c) {
        return "An IllegalAccessException occurred while creating the UsbServices implementation " + c;
    }

    private static final String USBSERVICES_CLASSCASTEXCEPTION(String c) {
        return "The class " + c + " does not implement UsbServices";
    }
}

