/*
 * Decompiled with CFR 0.152.
 */
package com.mcreations.usb.windows;

import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbHubImp;
import com.ibm.jusb.os.AbstractUsbServices;
import com.ibm.jusb.util.RunnableManager;
import com.mcreations.usb.windows.JavaxUsb;
import com.mcreations.usb.windows.Mutex;
import com.mcreations.usb.windows.WindowsHubOsImp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbServices;
import javax.usb.event.UsbServicesEvent;
import org.apache.log4j.Logger;

public class WindowsUsbServices
extends AbstractUsbServices
implements UsbServices {
    Logger log = Logger.getLogger(WindowsUsbServices.class);
    private RunnableManager topologyUpdateManager = new RunnableManager();
    private Object topologyLock = new Object();
    private Mutex topologyUpdateMutex = new Mutex();
    private Thread topologyListener = null;
    protected boolean topologyUpdateUsePolling = true;
    protected int topologyUpdateDelay = 5000;
    protected int topologyUpdateNewDeviceDelay = 500;
    private boolean firstUpdateDone = false;
    public static final String COULD_NOT_ACCESS_USB_SUBSYSTEM = "Could not access USB subsystem.";
    public static final int MAX_FIRST_UPDATE_DELAY = 10000;
    public static final int TOPOLOGY_UPDATE_DELAY = 5000;
    public static final String TOPOLOGY_UPDATE_DELAY_KEY = "com.mcreations.usb.windows.WindowsUsbServices.topologyUpdateDelay";
    public static final int TOPOLOGY_UPDATE_NEW_DEVICE_DELAY = 500;
    public static final String TOPOLOGY_UPDATE_NEW_DEVICE_DELAY_KEY = "com.mcreations.usb.windows.WindowsUsbServices.topologyUpdateNewDeviceDelay";
    public static final boolean TOPOLOGY_UPDATE_USE_POLLING = true;
    public static final String TOPOLOGY_UPDATE_USE_POLLING_KEY = "com.mcreations.usb.windows.WindowsUsbServices.topologyUpdateUsePolling";
    public static final String TRACING_KEY = "com.mcreations.usb.windows.WindowsUsbServices.JNI.tracing";
    public static final String TRACE_LEVEL_KEY = "com.mcreations.usb.windows.WindowsUsbServices.JNI.trace_level";
    public static final String TRACE_DEFAULT_KEY = "com.mcreations.usb.windows.WindowsUsbServices.JNI.trace_default";
    public static final String TRACE_HOTPLUG_KEY = "com.mcreations.usb.windows.WindowsUsbServices.JNI.trace_hotplug";
    public static final String TRACE_XFER_KEY = "com.mcreations.usb.windows.WindowsUsbServices.JNI.trace_xfer";
    public static final String TRACE_URB_KEY = "com.mcreations.usb.windows.WindowsUsbServices.JNI.trace_urb";
    public static final String WINDOWS_API_VERSION = "0.10.0";
    public static final String WINDOWS_IMP_VERSION = "0.10.0";
    public static final String WINDOWS_IMP_DESCRIPTION = "\tJSR80 : javax.usb\n\nImplementation for Windows 98, 2000, and XP.\n\n\n*\n* Copyright (c) 1999 - 2003, International Business Machines Corporation.\n* All Rights Reserved.\n*\n* This software is provided and licensed under the terms and conditions\n* of the Common Public License:\n* http://oss.software.ibm.com/developerworks/opensource/license-cpl.html\n\nhttp://javax-usb.org/\n\n";

    public WindowsUsbServices() throws UsbException {
        JavaxUsb.initialise();
        this.topologyUpdateManager.setMaxSize(Long.MAX_VALUE);
        this.checkProperties();
        this.startTopologyListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized UsbHub getRootUsbHub() throws UsbException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"getRootUsbHub() requested hub");
        }
        Object object = this.topologyLock;
        synchronized (object) {
            if (!this.firstUpdateDone) {
                try {
                    this.topologyLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.getRootUsbHubImp();
    }

    @Override
    public String getApiVersion() {
        return "0.10.0";
    }

    @Override
    public String getImpVersion() {
        return "0.10.0";
    }

    @Override
    public String getImpDescription() {
        return WINDOWS_IMP_DESCRIPTION;
    }

    private void checkProperties() {
        Properties p = null;
        try {
            p = UsbHostManager.getProperties();
        }
        catch (Exception e) {
            return;
        }
        try {
            if (p.containsKey(TOPOLOGY_UPDATE_DELAY_KEY)) {
                this.topologyUpdateDelay = Integer.decode(p.getProperty(TOPOLOGY_UPDATE_DELAY_KEY));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (p.containsKey(TOPOLOGY_UPDATE_NEW_DEVICE_DELAY_KEY)) {
                this.topologyUpdateNewDeviceDelay = Integer.decode(p.getProperty(TOPOLOGY_UPDATE_NEW_DEVICE_DELAY_KEY));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (p.containsKey(TOPOLOGY_UPDATE_USE_POLLING_KEY)) {
                this.topologyUpdateUsePolling = Boolean.valueOf(p.getProperty(TOPOLOGY_UPDATE_USE_POLLING_KEY));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (p.containsKey(TRACING_KEY)) {
                JavaxUsb.setTracing(Boolean.valueOf(p.getProperty(TRACING_KEY)));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (p.containsKey(TRACE_DEFAULT_KEY)) {
                JavaxUsb.setTraceType(Boolean.valueOf(p.getProperty(TRACE_DEFAULT_KEY)), "default");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (p.containsKey(TRACE_HOTPLUG_KEY)) {
                JavaxUsb.setTraceType(Boolean.valueOf(p.getProperty(TRACE_HOTPLUG_KEY)), "hotplug");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (p.containsKey(TRACE_XFER_KEY)) {
                JavaxUsb.setTraceType(Boolean.valueOf(p.getProperty(TRACE_XFER_KEY)), "xfer");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (p.containsKey(TRACE_URB_KEY)) {
                JavaxUsb.setTraceType(Boolean.valueOf(p.getProperty(TRACE_URB_KEY)), "urb");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (p.containsKey(TRACE_LEVEL_KEY)) {
                JavaxUsb.setTraceLevel(Integer.decode(p.getProperty(TRACE_LEVEL_KEY)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startTopologyListener() {
        Runnable r = null;
        String threadName = null;
        if (this.topologyUpdateUsePolling) {
            threadName = "USB Topology Poller";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("startTopologyListner started TopologyListner using polling with thread name <" + threadName + ">"));
            }
            r = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        WindowsUsbServices.this.topologyUpdateMutex.acquire();
                        WindowsUsbServices.this.updateTopology();
                        WindowsUsbServices.this.topologyUpdateMutex.release();
                        try {
                            Thread.sleep(WindowsUsbServices.this.topologyUpdateDelay);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
        } else {
            threadName = "USB Topology Listener";
            r = new Runnable(){

                @Override
                public void run() {
                    WindowsUsbServices.this.topologyListenerExit(JavaxUsb.nativeTopologyListener(WindowsUsbServices.this));
                }
            };
        }
        this.topologyListener = new Thread(r);
        this.topologyListener.setDaemon(true);
        this.topologyListener.setName(threadName);
        this.topologyListener.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTopology() {
        ArrayList connectedDevices = new ArrayList();
        ArrayList disconnectedDevices = new ArrayList();
        this.fillDeviceList(this.getRootUsbHubImp(), disconnectedDevices);
        while (disconnectedDevices.remove(this.getRootUsbHubImp())) {
        }
        int updates = JavaxUsb.nativeTopologyUpdater(this, connectedDevices, disconnectedDevices);
        if (updates == 0) {
            return;
        }
        for (UsbDeviceImp device : disconnectedDevices) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("updateTopology() disconnecting device: " + device));
            }
            device.disconnect();
            this.listenerImp.usbDeviceDetached(new UsbServicesEvent(this, device));
        }
        for (UsbDeviceImp device : connectedDevices) {
            try {
                if (!(device instanceof WindowsHubOsImp)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"sleeping to let new device settle");
                    }
                    Thread.sleep(this.topologyUpdateNewDeviceDelay);
                }
            }
            catch (InterruptedException iE) {
                // empty catch block
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("updateTopology() found device: " + device.getSerialNumberString()));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("updateTopology() connecting device: " + device));
            }
            this.listenerImp.usbDeviceAttached(new UsbServicesEvent(this, device));
        }
        Object object = this.topologyLock;
        synchronized (object) {
            this.firstUpdateDone = true;
            this.topologyLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void topologyListenerExit(int error) {
        Object object = this.topologyLock;
        synchronized (object) {
            this.topologyLock.notifyAll();
        }
    }

    protected boolean isUsbDevicesEqual(UsbDeviceImp dev1, UsbDeviceImp dev2) {
        try {
            UsbDeviceDescriptor desc1 = dev1.getUsbDeviceDescriptor();
            UsbDeviceDescriptor desc2 = dev2.getUsbDeviceDescriptor();
            return dev1.isUsbHub() == dev1.isUsbHub() && dev1.getSpeed() == dev2.getSpeed() && desc1.equals(desc2);
        }
        catch (NullPointerException npE) {
            return false;
        }
    }

    private void fillDeviceList(UsbDeviceImp device, List list) {
        list.add(device);
        if (device.isUsbHub()) {
            UsbHubImp hub = (UsbHubImp)device;
            Iterator iterator = hub.getAttachedUsbDevices().iterator();
            while (iterator.hasNext()) {
                this.fillDeviceList((UsbDeviceImp)iterator.next(), list);
            }
        }
    }
}

