/*
 * Decompiled with CFR 0.152.
 */
package com.mcreations.usb.windows;

import com.ibm.jusb.UsbInterfaceImp;
import com.ibm.jusb.os.DefaultUsbInterfaceOsImp;
import com.ibm.jusb.os.UsbInterfaceOsImp;
import com.mcreations.usb.windows.JavaxUsb;
import com.mcreations.usb.windows.WindowsDeviceOsImp;
import javax.usb.UsbClaimException;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbNotActiveException;
import net.sf.libusb.Libusb;
import net.sf.libusb.usb_config_descriptor;
import org.apache.log4j.Logger;

class WindowsInterfaceOsImp
extends DefaultUsbInterfaceOsImp
implements UsbInterfaceOsImp {
    Logger log = Logger.getLogger(WindowsInterfaceOsImp.class);
    protected UsbInterfaceImp usbInterfaceImp = null;
    protected WindowsDeviceOsImp windowsDeviceOsImp = null;
    private boolean interfaceNumberSet = false;
    private byte interfaceNumber = 0;

    public WindowsInterfaceOsImp(UsbInterfaceImp iface, WindowsDeviceOsImp device) {
        this.setUsbInterfaceImp(iface);
        this.setWindowsDeviceOsImp(device);
    }

    public UsbInterfaceImp getUsbInterfaceImp() {
        return this.usbInterfaceImp;
    }

    public void setUsbInterfaceImp(UsbInterfaceImp iface) {
        this.usbInterfaceImp = iface;
    }

    public WindowsDeviceOsImp getWindowsDeviceOsImp() {
        return this.windowsDeviceOsImp;
    }

    public void setWindowsDeviceOsImp(WindowsDeviceOsImp device) {
        this.windowsDeviceOsImp = device;
    }

    public byte getInterfaceNumber() {
        if (!this.interfaceNumberSet) {
            this.interfaceNumber = this.usbInterfaceImp.getUsbInterfaceDescriptor().bInterfaceNumber();
            this.interfaceNumberSet = true;
        }
        return this.interfaceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void claim(UsbInterfacePolicy policy) throws UsbClaimException, UsbException, UsbNotActiveException, UsbDisconnectedException {
        this.log.debug((Object)("Entering claim.with handle: " + this.getWindowsDeviceOsImp().getHandle() + "  iface: " + this.getInterfaceNumber()));
        JavaxUsb.getMutex().acquire();
        try {
            usb_config_descriptor ucd = this.getWindowsDeviceOsImp().getDevice().getConfig();
            this.log.debug((Object)("Setting libusb to configuration number: " + ucd.getIConfiguration()));
            int retval = Libusb.usb_set_configuration(this.getWindowsDeviceOsImp().getHandle(), ucd.getIConfiguration());
            JavaxUsb.isReturnCodeError(retval);
            retval = Libusb.usb_claim_interface(this.getWindowsDeviceOsImp().getHandle(), this.getInterfaceNumber());
            if (retval != 0) {
                String msg = "Couldn't claim interface. usb error: " + Libusb.usb_strerror();
                this.log.debug((Object)msg);
                throw new UsbClaimException(msg);
            }
        }
        finally {
            JavaxUsb.getMutex().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws UsbClaimException, UsbException, UsbNotActiveException, UsbDisconnectedException {
        JavaxUsb.getMutex().acquire();
        try {
            int result = Libusb.usb_release_interface(this.getWindowsDeviceOsImp().getHandle(), this.getInterfaceNumber());
            if (result != 0) {
                String msg = "Couldn't release interface. usb error: " + Libusb.usb_strerror();
                this.log.debug((Object)msg);
                throw new UsbClaimException(msg);
            }
        }
        finally {
            JavaxUsb.getMutex().release();
        }
    }

    public UsbInterfaceOsImp getUsbInterfaceOsImp() {
        return this;
    }
}

