/*
 * Decompiled with CFR 0.152.
 */
package com.mcreations.usb.windows;

import com.ibm.jusb.UsbControlIrpImp;
import com.ibm.jusb.UsbDeviceDescriptorImp;
import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbIrpImp;
import com.ibm.jusb.os.UsbDeviceOsImp;
import com.mcreations.usb.windows.JavaxUsb;
import java.util.List;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEncodingException;
import javax.usb.UsbException;
import javax.usb.util.UsbUtil;
import net.sf.libusb.Libusb;
import net.sf.libusb.SWIGTYPE_p_usb_dev_handle;
import net.sf.libusb.usb_device;
import net.sf.libusb.usb_device_descriptor;
import org.apache.log4j.Logger;

class WindowsDeviceOsImp
extends UsbDeviceImp
implements UsbDeviceOsImp {
    Logger log = Logger.getLogger(WindowsDeviceOsImp.class);
    private usb_device device;
    SWIGTYPE_p_usb_dev_handle handle = null;
    private static byte[] buffer = new byte[512];

    public WindowsDeviceOsImp(usb_device device) {
        this.device = device;
        this.setUsbDeviceDescriptor(this.setupDescriptor(device));
    }

    private UsbDeviceDescriptor setupDescriptor(usb_device device) {
        usb_device_descriptor libusbDesc = device.getDescriptor();
        UsbDeviceDescriptorImp desc = new UsbDeviceDescriptorImp((byte)libusbDesc.getBLength(), (byte)libusbDesc.getBDescriptorType(), (short)libusbDesc.getBcdUSB(), (byte)libusbDesc.getBDeviceClass(), (byte)libusbDesc.getBDeviceSubClass(), (byte)libusbDesc.getBDeviceProtocol(), (byte)libusbDesc.getBMaxPacketSize0(), (short)libusbDesc.getIdVendor(), (short)libusbDesc.getIdProduct(), (short)libusbDesc.getBcdDevice(), (byte)libusbDesc.getIManufacturer(), (byte)libusbDesc.getIProduct(), (byte)libusbDesc.getISerialNumber(), (byte)libusbDesc.getBNumConfigurations());
        return desc;
    }

    public void asyncSubmit(UsbIrpImp irp) throws UsbException {
        this.syncSubmit(irp);
    }

    @Override
    public void asyncSubmit(UsbControlIrpImp irp) throws UsbException {
        this.syncSubmit(irp);
    }

    @Override
    public void syncSubmit(UsbControlIrpImp irp) throws UsbException {
        this.syncSubmit((UsbIrpImp)irp);
    }

    public void syncSubmit(UsbIrpImp irp) throws UsbException {
        this.sendRequest(irp);
        irp.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(UsbIrpImp irp) throws UsbException {
        if (this.handle == null) {
            this.handle = this.getHandle();
        }
        if (irp instanceof UsbControlIrpImp) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"sendRequest() irp instance of UsbControlIrpImp");
            }
            UsbControlIrpImp cIrp = (UsbControlIrpImp)irp;
            JavaxUsb.getMutex().acquire();
            try {
                if (cIrp.bRequest() == 9 && cIrp.bmRequestType() == 0) {
                    int retval = Libusb.usb_set_configuration(this.getHandle(), cIrp.wValue());
                    JavaxUsb.isReturnCodeError(retval);
                    return;
                }
                byte[] data = cIrp.getData();
                if ((cIrp.bmRequestType() & 0xFFFFFF80) == 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("sendRequest() direction OUT Len: " + cIrp.wLength()));
                    }
                    byte[] data1 = cIrp.getData();
                    data = new byte[cIrp.wLength()];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = data1[i];
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("sendRequest() bmRequestType: " + UsbUtil.toHexString(cIrp.bmRequestType()) + "  bRequest: " + UsbUtil.toHexString(cIrp.bRequest()) + "  wValue: " + UsbUtil.toHexString(cIrp.wValue()) + "  wIndex: " + UsbUtil.toHexString(cIrp.wIndex()) + "  wLength: " + UsbUtil.toHexString(cIrp.wLength())));
                }
                int retval = Libusb.usb_control_msg(this.handle, cIrp.bmRequestType(), cIrp.bRequest(), cIrp.wValue(), cIrp.wIndex(), data, JavaxUsb.getIoTimeout());
                JavaxUsb.isReturnCodeError(retval);
                cIrp.setActualLength(retval);
            }
            finally {
                JavaxUsb.getMutex().release();
            }
        } else {
            throw new RuntimeException("Implement asyncSubmit for non-control Irp");
        }
    }

    @Override
    public void asyncSubmit(List list) throws UsbException, IllegalArgumentException, UsbDisconnectedException {
        super.asyncSubmit(list);
    }

    @Override
    public void syncSubmit(List list) throws UsbException, IllegalArgumentException, UsbDisconnectedException {
        super.syncSubmit(list);
    }

    @Override
    public UsbDeviceOsImp getUsbDeviceOsImp() {
        return this;
    }

    public usb_device getDevice() {
        return this.device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(byte index) throws UsbException, UsbEncodingException, UsbDisconnectedException {
        if (this.handle == null) {
            this.handle = this.getHandle();
        }
        JavaxUsb.getMutex().acquire();
        try {
            int retval = Libusb.usb_get_string_simple(this.handle, index, buffer);
            JavaxUsb.isReturnCodeError(retval);
        }
        finally {
            JavaxUsb.getMutex().release();
        }
        return JavaxUsb.bytes2String(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SWIGTYPE_p_usb_dev_handle getHandle() throws UsbException {
        if (this.handle == null) {
            JavaxUsb.getMutex().acquire();
            try {
                this.handle = Libusb.usb_open(this.device);
                if (this.handle == null) {
                    String msg = "Couldn't open device " + this.device.getFilename() + " due to error: " + Libusb.usb_strerror();
                    this.log.debug((Object)msg);
                    throw new UsbException(msg);
                }
                if (this.log.isDebugEnabled()) {
                    short serial;
                    short prod;
                    int retval;
                    int bufSize = 256;
                    byte[] buf = new byte[bufSize];
                    short manu = this.device.getDescriptor().getIManufacturer();
                    if (manu > 0) {
                        retval = Libusb.usb_get_string_simple(this.handle, manu, buf);
                        JavaxUsb.isReturnCodeError(retval);
                        this.log.debug((Object)("Manufacturer : <" + JavaxUsb.bytes2String(buf) + ">"));
                    }
                    if ((prod = this.device.getDescriptor().getIProduct()) > 0) {
                        retval = Libusb.usb_get_string_simple(this.handle, prod, buf);
                        JavaxUsb.isReturnCodeError(retval);
                        this.log.debug((Object)("Product      : <" + JavaxUsb.bytes2String(buf) + ">"));
                    }
                    if ((serial = this.device.getDescriptor().getISerialNumber()) > 0) {
                        retval = Libusb.usb_get_string_simple(this.handle, serial, buf);
                        JavaxUsb.isReturnCodeError(retval);
                        this.log.debug((Object)("Serial Number: <" + JavaxUsb.bytes2String(buf) + ">"));
                    }
                }
            }
            finally {
                JavaxUsb.getMutex().release();
            }
        }
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws UsbException {
        if (this.handle == null) {
            return;
        }
        JavaxUsb.getMutex().acquire();
        try {
            int retval = Libusb.usb_close(this.handle);
            if (retval != 0) {
                String msg = "Couldn't close device " + this.device.getFilename() + " due to error: " + Libusb.usb_strerror();
                this.log.debug((Object)msg);
                throw new UsbException(msg);
            }
            JavaxUsb.isReturnCodeError(retval);
        }
        finally {
            JavaxUsb.getMutex().release();
        }
        this.handle = null;
    }
}

