/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.tools.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.usb.UsbException;
import javax.usb.UsbPipe;
import javax.usb.util.DefaultUsbIrp;
import javax.usb.util.UsbUtil;

public class UsbIrpPanel
extends JPanel
implements Cloneable {
    private JPanel packetOptionsPanel = new JPanel();
    protected JCheckBox syncCheckBox = new JCheckBox("Sync", true);
    protected JCheckBox irpCheckBox = new JCheckBox("UsbIrp", true);
    protected JCheckBox acceptShortCheckBox = new JCheckBox("AcceptShort", true);
    private JLabel offsetLabel = new JLabel("Offset");
    protected JTextField offsetField = new JTextField(4);
    protected JCheckBox lengthCheckBox = new JCheckBox("Length", true);
    protected JTextField lengthField = new JTextField(4);
    private JPanel buttonPanel = new JPanel();
    private JButton refreshButton = new JButton("Refresh");
    private JButton clearButton = new JButton("Clear");
    protected JTextArea packetDataTextArea = new JTextArea();
    private JScrollPane packetDataScroll = new JScrollPane(this.packetDataTextArea);
    private byte[] lastData = null;
    private ActionListener refreshListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbIrpPanel.this.refresh();
        }
    };
    private ActionListener clearListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbIrpPanel.this.clear();
        }
    };
    private ChangeListener irpListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent cE) {
            UsbIrpPanel.this.irpSelectionChanged();
        }
    };
    private ChangeListener lengthListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent cE) {
            UsbIrpPanel.this.lengthSelectionChanged();
        }
    };

    public UsbIrpPanel() {
        this.setLayout(new BorderLayout());
        this.irpCheckBox.addChangeListener(this.irpListener);
        this.lengthCheckBox.addChangeListener(this.lengthListener);
        this.refreshButton.addActionListener(this.refreshListener);
        this.clearButton.addActionListener(this.clearListener);
        this.offsetField.setText("0");
        this.lengthField.setText("0");
        this.lengthCheckBox.setSelected(false);
        this.packetOptionsPanel.add(this.syncCheckBox);
        this.packetOptionsPanel.add(this.irpCheckBox);
        this.packetOptionsPanel.add(this.offsetLabel);
        this.packetOptionsPanel.add(this.offsetField);
        this.packetOptionsPanel.add(this.lengthCheckBox);
        this.packetOptionsPanel.add(this.lengthField);
        this.packetOptionsPanel.add(this.acceptShortCheckBox);
        this.buttonPanel.add(this.refreshButton);
        this.buttonPanel.add(this.clearButton);
        this.add((Component)this.packetOptionsPanel, "North");
        this.add((Component)this.packetDataScroll, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    @Override
    public String toString() {
        return "Buffer @" + UsbUtil.toHexString(this.hashCode());
    }

    public Object clone() {
        UsbIrpPanel newPanel = new UsbIrpPanel();
        newPanel.syncCheckBox.setSelected(this.syncCheckBox.isSelected());
        newPanel.irpCheckBox.setSelected(this.irpCheckBox.isSelected());
        newPanel.acceptShortCheckBox.setSelected(this.acceptShortCheckBox.isSelected());
        newPanel.acceptShortCheckBox.setEnabled(this.acceptShortCheckBox.isEnabled());
        newPanel.packetDataTextArea.setText(this.packetDataTextArea.getText());
        return newPanel;
    }

    public void submit(UsbPipe pipe) throws UsbException, NumberFormatException {
        this.lastData = this.getData();
        if (this.irpCheckBox.isSelected()) {
            DefaultUsbIrp irp = new DefaultUsbIrp();
            irp.setData(this.lastData);
            irp.setOffset(this.getOffset());
            irp.setLength(this.getLength(this.lastData));
            irp.setAcceptShortPacket(this.acceptShortCheckBox.isSelected());
            if (this.syncCheckBox.isSelected()) {
                pipe.syncSubmit(irp);
            } else {
                pipe.asyncSubmit(irp);
            }
        } else if (this.syncCheckBox.isSelected()) {
            pipe.syncSubmit(this.lastData);
        } else {
            pipe.asyncSubmit(this.lastData);
        }
    }

    protected byte[] getData() {
        ArrayList<Byte> list = new ArrayList<Byte>();
        StringTokenizer tokenizer = new StringTokenizer(this.packetDataTextArea.getText());
        while (tokenizer.hasMoreTokens()) {
            byte b;
            String token = tokenizer.nextToken();
            try {
                b = (byte)Integer.decode(token).intValue();
            }
            catch (NumberFormatException nfE) {
                if (3 == token.length() && ('\"' == token.charAt(0) && '\"' == token.charAt(2) || '\'' == token.charAt(0) && '\'' == token.charAt(2))) {
                    b = (byte)token.charAt(1);
                }
                throw nfE;
            }
            list.add(new Byte(b));
        }
        byte[] data = new byte[list.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (Byte)list.get(i);
        }
        return data;
    }

    protected int getOffset() {
        return Integer.decode(this.offsetField.getText());
    }

    protected int getLength(byte[] data) {
        if (this.lengthCheckBox.isSelected()) {
            return Integer.decode(this.lengthField.getText());
        }
        return data.length;
    }

    protected void refresh() {
        if (null == this.lastData) {
            return;
        }
        if (!Arrays.equals(this.lastData, this.getData())) {
            this.packetDataTextArea.setText("");
            for (int i = 0; i < this.lastData.length; ++i) {
                this.packetDataTextArea.append("0x" + UsbUtil.toHexString(this.lastData[i]) + " ");
            }
        }
    }

    protected void clear() {
        this.packetDataTextArea.setText("");
    }

    protected void irpSelectionChanged() {
        if (this.irpCheckBox.isSelected()) {
            this.offsetField.setEnabled(true);
            this.lengthCheckBox.setEnabled(true);
            this.lengthField.setEnabled(this.lengthCheckBox.isSelected());
            this.acceptShortCheckBox.setEnabled(true);
        } else {
            this.offsetField.setEnabled(false);
            this.lengthCheckBox.setEnabled(false);
            this.lengthField.setEnabled(false);
            this.acceptShortCheckBox.setEnabled(false);
        }
    }

    protected void lengthSelectionChanged() {
        if (this.irpCheckBox.isSelected()) {
            this.lengthField.setEnabled(this.lengthCheckBox.isSelected());
        }
    }
}

