/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.tools.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.util.DefaultUsbControlIrp;
import javax.usb.util.UsbUtil;

public class UsbControlIrpPanel
extends JPanel
implements Cloneable {
    private JPanel packetOptionsPanel = new JPanel();
    protected JCheckBox syncCheckBox = new JCheckBox("Sync", true);
    private JLabel offsetLabel = new JLabel("Offset");
    protected JTextField offsetField = new JTextField(4);
    protected JCheckBox lengthCheckBox = new JCheckBox("Length", true);
    protected JTextField lengthField = new JTextField(4);
    protected JCheckBox acceptShortCheckBox = new JCheckBox("AcceptShort", true);
    private JPanel selectionPanel = new JPanel();
    private Vector requestTypeVector = new Vector();
    private Box bmRequestTypeBox = new Box(0);
    private JLabel bmRequestTypeLabel = new JLabel("bmReqType");
    private JPanel bmRequestTypePanel = new JPanel();
    protected JTextField bmRequestTypeField = new JTextField("0x00", 4);
    private Box bRequestBox = new Box(0);
    private JLabel bRequestLabel = new JLabel("bRequest");
    private JPanel bRequestPanel = new JPanel();
    protected JTextField bRequestField = new JTextField("0x00", 4);
    private Box wValueBox = new Box(0);
    private JLabel wValueLabel = new JLabel("wValue");
    private JPanel wValuePanel = new JPanel();
    protected JTextField wValueField = new JTextField("0x0000", 6);
    private Box wIndexBox = new Box(0);
    private JLabel wIndexLabel = new JLabel("wIndex");
    private JPanel wIndexPanel = new JPanel();
    protected JTextField wIndexField = new JTextField("0x0000", 6);
    private JButton refreshButton = new JButton("Refresh");
    private JButton clearButton = new JButton("Clear Data");
    protected JTextArea packetDataTextArea = new JTextArea(3, 25);
    private JScrollPane packetDataScroll = new JScrollPane(this.packetDataTextArea);
    private JButton resetButton = new JButton("Reset All");
    private byte[] lastData = null;
    private ActionListener refreshListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbControlIrpPanel.this.refresh();
        }
    };
    private ActionListener clearListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbControlIrpPanel.this.clear();
        }
    };
    private ActionListener resetListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbControlIrpPanel.this.reset();
        }
    };
    private ChangeListener lengthListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent cE) {
            UsbControlIrpPanel.this.lengthSelectionChanged();
        }
    };

    public UsbControlIrpPanel() {
        this.setLayout(new BorderLayout());
        this.refreshButton.addActionListener(this.refreshListener);
        this.clearButton.addActionListener(this.clearListener);
        this.resetButton.addActionListener(this.resetListener);
        this.lengthCheckBox.addChangeListener(this.lengthListener);
        this.offsetField.setText("0");
        this.lengthField.setText("0");
        this.lengthCheckBox.setSelected(false);
        JPanel setupPacketPanel = new JPanel(new GridLayout(4, 2, 6, 6));
        setupPacketPanel.add(this.bmRequestTypeLabel);
        setupPacketPanel.add(this.bmRequestTypeField);
        setupPacketPanel.add(this.bRequestLabel);
        setupPacketPanel.add(this.bRequestField);
        setupPacketPanel.add(this.wValueLabel);
        setupPacketPanel.add(this.wValueField);
        setupPacketPanel.add(this.wIndexLabel);
        setupPacketPanel.add(this.wIndexField);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)setupPacketPanel, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        this.selectionPanel.add(this.syncCheckBox);
        this.selectionPanel.add(this.syncCheckBox);
        this.selectionPanel.add(this.offsetLabel);
        this.selectionPanel.add(this.offsetField);
        this.selectionPanel.add(this.lengthCheckBox);
        this.selectionPanel.add(this.lengthField);
        this.selectionPanel.add(this.acceptShortCheckBox);
        JPanel buttonsPanel = new JPanel();
        JPanel insidePanel = new JPanel(new GridLayout(1, 3, 8, 2));
        insidePanel.add(this.refreshButton);
        insidePanel.add(this.clearButton);
        insidePanel.add(this.resetButton);
        buttonsPanel.add(insidePanel);
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)this.selectionPanel, "North");
        rightPanel.add((Component)this.packetDataScroll, "Center");
        rightPanel.add((Component)buttonsPanel, "South");
        rightPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 5));
        this.add((Component)panel, "West");
        this.add((Component)rightPanel, "Center");
    }

    @Override
    public String toString() {
        return "Buffer @" + UsbUtil.toHexString(this.hashCode());
    }

    public Object clone() {
        UsbControlIrpPanel newPanel = new UsbControlIrpPanel();
        newPanel.syncCheckBox.setSelected(this.syncCheckBox.isSelected());
        newPanel.packetDataTextArea.setText(this.packetDataTextArea.getText());
        newPanel.bmRequestTypeField.setText(this.bmRequestTypeField.getText());
        newPanel.bRequestField.setText(this.bRequestField.getText());
        newPanel.wIndexField.setText(this.wIndexField.getText());
        newPanel.wValueField.setText(this.wValueField.getText());
        newPanel.offsetField.setText(this.offsetField.getText());
        newPanel.lengthField.setText(this.lengthField.getText());
        return newPanel;
    }

    public void submit(UsbDevice device) throws UsbException, NumberFormatException {
        this.lastData = this.getData();
        byte bmRequestType = (byte)Integer.decode(this.bmRequestTypeField.getText()).intValue();
        byte bRequest = (byte)Integer.decode(this.bRequestField.getText()).intValue();
        short wValue = (short)Integer.decode(this.wValueField.getText()).intValue();
        short wIndex = (short)Integer.decode(this.wIndexField.getText()).intValue();
        DefaultUsbControlIrp usbControlIrp = new DefaultUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        usbControlIrp.setData(this.lastData);
        usbControlIrp.setOffset(this.getOffset());
        usbControlIrp.setLength(this.getLength(this.lastData));
        usbControlIrp.setAcceptShortPacket(this.acceptShortCheckBox.isSelected());
        if (this.syncCheckBox.isSelected()) {
            device.syncSubmit(usbControlIrp);
        } else {
            device.asyncSubmit(usbControlIrp);
        }
    }

    protected byte[] getData() {
        ArrayList<Byte> list = new ArrayList<Byte>();
        StringTokenizer tokenizer = new StringTokenizer(this.packetDataTextArea.getText());
        while (tokenizer.hasMoreTokens()) {
            byte b;
            String token = tokenizer.nextToken();
            try {
                b = (byte)Integer.decode(token).intValue();
            }
            catch (NumberFormatException nfE) {
                if (3 == token.length() && ('\"' == token.charAt(0) && '\"' == token.charAt(2) || '\'' == token.charAt(0) && '\'' == token.charAt(2))) {
                    b = (byte)token.charAt(1);
                }
                throw nfE;
            }
            list.add(new Byte(b));
        }
        byte[] data = new byte[list.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (Byte)list.get(i);
        }
        return data;
    }

    protected int getOffset() {
        return Integer.decode(this.offsetField.getText());
    }

    protected int getLength(byte[] data) {
        if (this.lengthCheckBox.isSelected()) {
            return Integer.decode(this.lengthField.getText());
        }
        return data.length;
    }

    protected void refresh() {
        if (null == this.lastData) {
            return;
        }
        if (!Arrays.equals(this.lastData, this.getData())) {
            this.packetDataTextArea.setText("");
            for (int i = 0; i < this.lastData.length; ++i) {
                this.packetDataTextArea.append("0x" + UsbUtil.toHexString(this.lastData[i]) + " ");
            }
        }
    }

    protected void clear() {
        this.packetDataTextArea.setText("");
    }

    protected void reset() {
        this.packetDataTextArea.setText("");
        this.offsetField.setText("0");
        this.lengthField.setText("0");
        this.bmRequestTypeField.setText("0x00");
        this.bRequestField.setText("0x00");
        this.wValueField.setText("0x0000");
        this.wIndexField.setText("0x0000");
        this.syncCheckBox.setSelected(true);
        this.acceptShortCheckBox.setSelected(true);
        this.lengthCheckBox.setSelected(false);
    }

    protected void lengthSelectionChanged() {
        this.lengthField.setEnabled(this.lengthCheckBox.isSelected());
    }
}

