/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.tools.swing;

import com.ibm.jusb.tools.swing.UsbConfigurationPanel;
import com.ibm.jusb.tools.swing.UsbDevicePanel;
import com.ibm.jusb.tools.swing.UsbEndpointPanel;
import com.ibm.jusb.tools.swing.UsbHubPanel;
import com.ibm.jusb.tools.swing.UsbInterfacePanel;
import com.ibm.jusb.tools.swing.UsbPanel;
import com.ibm.jusb.tools.swing.UsbPipePanel;
import com.ibm.jusb.tools.swing.UsbPortPanel;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbEndpoint;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbPort;
import javax.usb.UsbServices;
import javax.usb.event.UsbServicesEvent;
import javax.usb.event.UsbServicesListener;
import javax.usb.util.UsbUtil;

public class SwingUsbView {
    protected UsbHub rootHub = null;
    protected JFrame frame = new JFrame("UsbView");
    protected Hashtable deviceTable = new Hashtable();
    protected DefaultMutableTreeNode rootNode = null;
    protected DefaultTreeModel treeModel = null;
    protected JTree tree = null;
    protected JScrollPane treeScroll = null;
    protected JSplitPane splitPane = new JSplitPane(1, null, null);
    protected UsbServicesListener topologyListener = new UsbServicesListener(){

        @Override
        public void usbDeviceAttached(UsbServicesEvent usE) {
            UsbDevice device = usE.getUsbDevice();
            if (SwingUsbView.this.deviceTable.containsKey(device)) {
                return;
            }
            if (SwingUsbView.this.deviceTable.containsKey(device.getParentUsbPort().getUsbHub())) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)SwingUsbView.this.deviceTable.get(device.getParentUsbPort().getUsbHub());
                int index = UsbUtil.unsignedInt(device.getParentUsbPort().getPortNumber()) - 1;
                while (parent.getChildCount() <= index) {
                    parent.add(SwingUsbView.this.getPortNode(device.getParentUsbPort().getUsbHub().getUsbPort((byte)(parent.getChildCount() + 1))));
                    SwingUsbView.this.treeModel.reload(parent);
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(UsbUtil.unsignedInt(device.getParentUsbPort().getPortNumber()) - 1);
                if (device.isUsbHub()) {
                    node.setUserObject(new UsbHubPanel((UsbHub)device));
                    SwingUsbView.this.createTree((UsbHub)device, node);
                } else {
                    node.setUserObject(new UsbDevicePanel(device));
                    SwingUsbView.this.createDevice(device, node);
                }
                SwingUsbView.this.treeModel.reload(node);
                SwingUsbView.this.deviceTable.put(device, node);
            }
        }

        @Override
        public void usbDeviceDetached(UsbServicesEvent usE) {
            UsbDevice device = usE.getUsbDevice();
            if (SwingUsbView.this.deviceTable.containsKey(device)) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)SwingUsbView.this.deviceTable.get(device);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                if (null != parent) {
                    UsbHub parentHub = ((UsbHubPanel)parent.getUserObject()).getUsbHub();
                    byte portNumber = (byte)(parent.getIndex(node) + 1);
                    node.setUserObject(new UsbPortPanel(parentHub.getUsbPort(portNumber)));
                    node.removeAllChildren();
                    SwingUsbView.this.treeModel.reload(node);
                }
                SwingUsbView.this.deviceTable.remove(device);
            }
        }
    };
    protected TreeExpansionListener expansionListener = new TreeExpansionListener(){

        @Override
        public void treeCollapsed(TreeExpansionEvent teE) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent teE) {
        }
    };
    protected TreeSelectionListener selectionListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent tsE) {
            if (tsE.isAddedPath()) {
                int dividerLocation = SwingUsbView.this.splitPane.getDividerLocation();
                SwingUsbView.this.splitPane.setRightComponent((UsbPanel)((DefaultMutableTreeNode)tsE.getPath().getLastPathComponent()).getUserObject());
                SwingUsbView.this.splitPane.setDividerLocation(dividerLocation);
            }
        }
    };
    protected static final Dimension DEFAULT_SIZE = new Dimension(640, 480);
    protected static final Dimension MID_SIZE = new Dimension(800, 600);

    public SwingUsbView(UsbServices services, UsbHub hub) {
        this.rootHub = hub;
        this.rootNode = new DefaultMutableTreeNode(new UsbHubPanel(this.rootHub));
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.treeScroll = new JScrollPane(this.tree);
        this.splitPane.setLeftComponent(this.treeScroll);
        this.frame.getContentPane().add(this.splitPane);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setEditable(false);
        this.tree.addTreeSelectionListener(this.selectionListener);
        this.tree.addTreeExpansionListener(this.expansionListener);
        this.deviceTable.put(this.rootHub, this.rootNode);
        services.addUsbServicesListener(this.topologyListener);
        this.createTree(this.rootHub, this.rootNode);
        this.tree.setSelectionPath(new TreePath(this.rootNode.getPath()));
        this.frame.setSize(MID_SIZE);
    }

    public static void main(String[] argv) throws Exception {
        UsbServices services = UsbHostManager.getUsbServices();
        SwingUsbView s = new SwingUsbView(services, services.getRootUsbHub());
        s.frame.setDefaultCloseOperation(3);
        s.frame.setVisible(true);
        s.splitPane.setDividerLocation(0.35);
    }

    protected synchronized void createTree(UsbHub hub, DefaultMutableTreeNode node) {
        for (UsbPort port : hub.getUsbPorts()) {
            DefaultMutableTreeNode child = null;
            if (port.isUsbDeviceAttached()) {
                UsbDevice device = port.getUsbDevice();
                if (device.isUsbHub()) {
                    child = this.getHubNode((UsbHub)device);
                    this.createTree((UsbHub)device, child);
                } else {
                    child = this.getDeviceNode(device);
                    this.createDevice(device, child);
                }
                this.deviceTable.put(device, child);
            } else {
                child = this.getPortNode(port);
            }
            node.add(child);
        }
        this.treeModel.reload(node);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.tree.expandPath(new TreePath(((DefaultMutableTreeNode)node.getChildAt(i)).getPath()));
        }
    }

    protected void createDevice(UsbDevice device, DefaultMutableTreeNode node) {
        for (UsbConfiguration configuration : device.getUsbConfigurations()) {
            DefaultMutableTreeNode child = this.getConfigurationNode(configuration);
            this.createConfiguration(configuration, child);
            node.add(child);
        }
    }

    protected void createConfiguration(UsbConfiguration configuration, DefaultMutableTreeNode node) {
        for (UsbInterface iface : configuration.getUsbInterfaces()) {
            for (UsbInterface setting : iface.getSettings()) {
                DefaultMutableTreeNode child = this.getInterfaceNode(setting);
                this.createInterface(setting, child);
                node.add(child);
            }
        }
    }

    protected void createInterface(UsbInterface iface, DefaultMutableTreeNode node) {
        for (UsbEndpoint ep : iface.getUsbEndpoints()) {
            DefaultMutableTreeNode child = this.getEndpointNode(ep);
            this.createEndpoint(ep, child);
            node.add(child);
        }
    }

    protected void createEndpoint(UsbEndpoint ep, DefaultMutableTreeNode node) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(new UsbPipePanel(ep.getUsbPipe()));
        node.add(child);
    }

    protected DefaultMutableTreeNode getHubNode(UsbHub hub) {
        return new DefaultMutableTreeNode(new UsbHubPanel(hub));
    }

    protected DefaultMutableTreeNode getPortNode(UsbPort port) {
        return new DefaultMutableTreeNode(new UsbPortPanel(port));
    }

    protected DefaultMutableTreeNode getDeviceNode(UsbDevice device) {
        return new DefaultMutableTreeNode(new UsbDevicePanel(device));
    }

    protected DefaultMutableTreeNode getConfigurationNode(UsbConfiguration configuration) {
        return new DefaultMutableTreeNode(new UsbConfigurationPanel(configuration));
    }

    protected DefaultMutableTreeNode getInterfaceNode(UsbInterface iface) {
        return new DefaultMutableTreeNode(new UsbInterfacePanel(iface));
    }

    protected DefaultMutableTreeNode getEndpointNode(UsbEndpoint ep) {
        return new DefaultMutableTreeNode(new UsbEndpointPanel(ep));
    }
}

