/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.linux;

import com.ibm.jusb.os.linux.LinuxRequestProxy;

abstract class LinuxRequest {
    private LinuxRequestProxy linuxRequestProxy = null;
    private Object waitLock = new Object();
    private int waitCount = 0;
    private boolean completed = false;
    private int errorNumber = 0;
    private Completion completion = null;
    public static final int LINUX_PIPE_REQUEST = 1;
    public static final int LINUX_SET_INTERFACE_REQUEST = 2;
    public static final int LINUX_SET_CONFIGURATION_REQUEST = 3;
    public static final int LINUX_CLAIM_INTERFACE_REQUEST = 4;
    public static final int LINUX_IS_CLAIMED_INTERFACE_REQUEST = 5;
    public static final int LINUX_RELEASE_INTERFACE_REQUEST = 6;
    public static final int LINUX_ISOCHRONOUS_REQUEST = 7;

    LinuxRequest() {
    }

    public abstract int getType();

    public int getError() {
        return this.errorNumber;
    }

    public void setError(int error) {
        this.errorNumber = error;
    }

    public void waitUntilCompleted() {
        this.waitUntilCompleted(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilCompleted(long timeout) {
        long start = System.currentTimeMillis();
        boolean use_timeout = 0L < timeout;
        Object object = this.waitLock;
        synchronized (object) {
            ++this.waitCount;
            while (!this.isCompleted()) {
                long elapsed = System.currentTimeMillis() - start;
                if (use_timeout && elapsed > timeout) break;
                try {
                    this.waitLock.wait(1000L);
                }
                catch (InterruptedException iE) {}
            }
            --this.waitCount;
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean c) {
        this.completed = c;
        if (this.completed) {
            this.notifyCompleted();
            this.executeCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCompleted() {
        Object object = this.waitLock;
        synchronized (object) {
            if (0 < this.waitCount) {
                this.waitLock.notifyAll();
            }
        }
    }

    protected void executeCompletion() {
        try {
            this.getCompletion().linuxRequestComplete(this);
        }
        catch (NullPointerException npE) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCompletion(Completion c) {
        this.completion = c;
    }

    public Completion getCompletion() {
        return this.completion;
    }

    public static interface Completion {
        public void linuxRequestComplete(LinuxRequest var1);
    }
}

