/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.linux;

import com.ibm.jusb.UsbInterfaceImp;
import com.ibm.jusb.os.UsbInterfaceOsImp;
import com.ibm.jusb.os.linux.JavaxUsb;
import com.ibm.jusb.os.linux.LinuxDeviceOsImp;
import com.ibm.jusb.os.linux.LinuxInterfaceRequest;
import com.ibm.jusb.os.linux.LinuxRequest;
import javax.usb.UsbException;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbNativeClaimException;

class LinuxInterfaceOsImp
implements UsbInterfaceOsImp {
    protected UsbInterfaceImp usbInterfaceImp = null;
    protected LinuxDeviceOsImp linuxDeviceOsImp = null;
    private byte interfaceNumber = 0;

    public LinuxInterfaceOsImp(UsbInterfaceImp iface, LinuxDeviceOsImp device) {
        this.setUsbInterfaceImp(iface);
        this.setLinuxDeviceOsImp(device);
    }

    public UsbInterfaceImp getUsbInterfaceImp() {
        return this.usbInterfaceImp;
    }

    public void setUsbInterfaceImp(UsbInterfaceImp iface) {
        this.usbInterfaceImp = iface;
        try {
            this.interfaceNumber = this.usbInterfaceImp.getUsbInterfaceDescriptor().bInterfaceNumber();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public LinuxDeviceOsImp getLinuxDeviceOsImp() {
        return this.linuxDeviceOsImp;
    }

    public void setLinuxDeviceOsImp(LinuxDeviceOsImp device) {
        this.linuxDeviceOsImp = device;
    }

    @Override
    public void claim() throws UsbException {
        LinuxInterfaceRequest.LinuxClaimInterfaceRequest request = new LinuxInterfaceRequest.LinuxClaimInterfaceRequest(this.getInterfaceNumber());
        this.submit(request);
        ((LinuxRequest)request).waitUntilCompleted();
        if (0 != ((LinuxRequest)request).getError()) {
            throw JavaxUsb.errorToUsbException(((LinuxRequest)request).getError(), "Could not claim interface");
        }
    }

    @Override
    public void claim(UsbInterfacePolicy policy) throws UsbException {
        boolean forceClaim = policy.forceClaim(this.getUsbInterfaceImp());
        LinuxInterfaceRequest.LinuxClaimInterfaceRequest request = new LinuxInterfaceRequest.LinuxClaimInterfaceRequest(this.getInterfaceNumber(), forceClaim);
        this.submit(request);
        ((LinuxRequest)request).waitUntilCompleted();
        if (0 != ((LinuxRequest)request).getError()) {
            throw JavaxUsb.errorToUsbException(((LinuxRequest)request).getError(), "Could not claim interface");
        }
    }

    @Override
    public void release() throws UsbException {
        LinuxInterfaceRequest.LinuxReleaseInterfaceRequest request = new LinuxInterfaceRequest.LinuxReleaseInterfaceRequest(this.getInterfaceNumber());
        this.submit(request);
        ((LinuxRequest)request).waitUntilCompleted();
        if (0 != ((LinuxRequest)request).getError()) {
            throw new UsbNativeClaimException(JavaxUsb.errorToUsbException(((LinuxRequest)request).getError()).getMessage());
        }
    }

    @Override
    public boolean isClaimed() {
        LinuxInterfaceRequest.LinuxIsClaimedInterfaceRequest request = new LinuxInterfaceRequest.LinuxIsClaimedInterfaceRequest(this.getInterfaceNumber());
        try {
            this.submit(request);
        }
        catch (UsbException uE) {
            return false;
        }
        ((LinuxRequest)request).waitUntilCompleted();
        if (0 != ((LinuxRequest)request).getError()) {
            return false;
        }
        return ((LinuxInterfaceRequest)request).isClaimed();
    }

    public byte getInterfaceNumber() {
        return this.interfaceNumber;
    }

    void submit(LinuxRequest request) throws UsbException {
        this.getLinuxDeviceOsImp().submit(request);
    }

    void cancel(LinuxRequest request) {
        this.getLinuxDeviceOsImp().cancel(request);
    }
}

