/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.linux;

import com.ibm.jusb.UsbControlIrpImp;
import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbEndpointImp;
import com.ibm.jusb.UsbInterfaceImp;
import com.ibm.jusb.os.DefaultUsbDeviceOsImp;
import com.ibm.jusb.os.UsbDeviceOsImp;
import com.ibm.jusb.os.linux.LinuxControlRequest;
import com.ibm.jusb.os.linux.LinuxDeviceProxy;
import com.ibm.jusb.os.linux.LinuxRequest;
import com.ibm.jusb.os.linux.LinuxSetConfigurationRequest;
import com.ibm.jusb.os.linux.LinuxSetInterfaceRequest;
import java.util.List;
import javax.usb.UsbException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbPlatformException;
import javax.usb.util.UsbUtil;

class LinuxDeviceOsImp
extends DefaultUsbDeviceOsImp
implements UsbDeviceOsImp {
    private UsbDeviceImp usbDeviceImp = null;
    private LinuxDeviceProxy linuxDeviceProxy = null;
    private String key = "";

    public LinuxDeviceOsImp(UsbDeviceImp device, LinuxDeviceProxy proxy) {
        this.setUsbDeviceImp(device);
        this.setLinuxDeviceProxy(proxy);
    }

    public UsbDeviceImp getUsbDeviceImp() {
        return this.usbDeviceImp;
    }

    public void setUsbDeviceImp(UsbDeviceImp device) {
        this.usbDeviceImp = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinuxDeviceProxy getLinuxDeviceProxy() throws UsbException {
        LinuxDeviceProxy linuxDeviceProxy = this.linuxDeviceProxy;
        synchronized (linuxDeviceProxy) {
            if (!this.linuxDeviceProxy.isRunning()) {
                this.linuxDeviceProxy.start();
            }
        }
        return this.linuxDeviceProxy;
    }

    public void setLinuxDeviceProxy(LinuxDeviceProxy proxy) {
        this.linuxDeviceProxy = proxy;
        this.key = this.linuxDeviceProxy.getKey();
    }

    @Override
    public void asyncSubmit(UsbControlIrpImp usbControlIrpImp) throws UsbException {
        LinuxControlRequest request = null;
        try {
            this.checkUnclaimedInterface(usbControlIrpImp);
        }
        catch (UsbPlatformException upE) {
            usbControlIrpImp.setUsbException(upE);
            usbControlIrpImp.complete();
            throw upE;
        }
        request = usbControlIrpImp.isSetConfiguration() ? new LinuxSetConfigurationRequest() : (usbControlIrpImp.isSetInterface() ? new LinuxSetInterfaceRequest() : new LinuxControlRequest());
        ((LinuxControlRequest)request).setUsbIrpImp(usbControlIrpImp);
        this.submit(request);
    }

    public String getKey() {
        return this.key;
    }

    void submit(LinuxRequest request) throws UsbException {
        this.getLinuxDeviceProxy().submit(request);
    }

    void cancel(LinuxRequest request) {
        try {
            this.getLinuxDeviceProxy().cancel(request);
        }
        catch (UsbException usbException) {
            // empty catch block
        }
    }

    protected void checkUnclaimedInterface(UsbControlIrpImp irp) throws UsbPlatformException {
        UsbInterfaceImp iface;
        if (64 == (byte)(0x60 & irp.bmRequestType())) {
            return;
        }
        if (1 == (byte)(0x1F & irp.bmRequestType())) {
            byte ifacenum = (byte)irp.wIndex();
            iface = this.interfaceNumberToUsbInterfaceImp(ifacenum);
            String iStr = "0x" + UsbUtil.toHexString(ifacenum);
            if (null == iface) {
                IllegalArgumentException iaE = new IllegalArgumentException("No active interface with number " + iStr);
                throw new UsbPlatformException("Request with recipient interface " + iStr + ", but no such interface in current active configuration", (Exception)iaE);
            }
            if (!iface.isJavaClaimed()) {
                UsbNotClaimedException uncE = new UsbNotClaimedException("Interface " + iStr + " is not claimed");
                throw new UsbPlatformException("Request with recipient interface " + iStr + ", but interface is not claimed", (Exception)uncE);
            }
        }
        if (2 == (byte)(0x1F & irp.bmRequestType())) {
            byte epNum = (byte)irp.wIndex();
            if (0 == epNum) {
                return;
            }
            iface = this.endpointAddressToUsbInterfaceImp(epNum);
            String eStr = "0x" + UsbUtil.toHexString(epNum);
            if (null == iface) {
                IllegalArgumentException iaE = new IllegalArgumentException("No active enpoint with address " + eStr);
                throw new UsbPlatformException("Request with recipient endpoint " + eStr + ", but no such endpoint in current active configuration and interfaces", (Exception)iaE);
            }
            if (!iface.isJavaClaimed()) {
                String iStr = "0x" + UsbUtil.toHexString(iface.getUsbInterfaceDescriptor().bInterfaceNumber());
                UsbNotClaimedException uncE = new UsbNotClaimedException("Interface " + iStr + ", which owns endpoint " + eStr + ", is not claimed");
                throw new UsbPlatformException("Request with recipient endpoint " + eStr + " which belongs to interface " + iStr + ", but interface is not claimed", (Exception)uncE);
            }
        }
    }

    protected UsbInterfaceImp interfaceNumberToUsbInterfaceImp(byte num) {
        return this.getUsbDeviceImp().getActiveUsbConfigurationImp().getUsbInterfaceImp(num);
    }

    protected UsbInterfaceImp endpointAddressToUsbInterfaceImp(byte addr) {
        List ifaces = this.getUsbDeviceImp().getActiveUsbConfigurationImp().getUsbInterfaces();
        for (int i = 0; i < ifaces.size(); ++i) {
            UsbInterfaceImp iface = (UsbInterfaceImp)ifaces.get(i);
            List eps = iface.getUsbEndpoints();
            for (int e = 0; e < eps.size(); ++e) {
                UsbEndpointImp ep = (UsbEndpointImp)eps.get(e);
                if (ep.getUsbEndpointDescriptor().bEndpointAddress() != addr) continue;
                return iface;
            }
        }
        return null;
    }
}

